/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.providers;

import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FilterController;
import com.kms.katalon.entity.file.FileEntity;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.Viewer;

public class EntityViewerFilter
extends AbstractEntityViewerFilter {
    private String searchString;
    private EntityProvider entityProvider;
    private Predicate<ITreeEntity> showItemPredicate;

    public EntityViewerFilter(EntityProvider entityProvider) {
        this(entityProvider, te -> true);
    }

    public EntityViewerFilter(EntityProvider entityProvider, Predicate<ITreeEntity> showItemPredicate) {
        this.entityProvider = entityProvider;
        this.showItemPredicate = showItemPredicate;
    }

    @Override
    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ITreeEntity) {
            try {
                boolean isShow = this.showItemPredicate.test((ITreeEntity)element);
                if (!isShow) {
                    return false;
                }
            }
            catch (Exception e) {
                LoggerSingleton.getInstance().getLogger().error((Throwable)e);
            }
        }
        if (this.searchString == null || this.searchString.equals("")) {
            return true;
        }
        if (element instanceof ITreeEntity) {
            boolean returnValue = false;
            try {
                returnValue |= this.searchElement(element);
            }
            catch (Exception e) {
                LoggerSingleton.getInstance().getLogger().error((Throwable)e);
            }
            if (returnValue) {
                return true;
            }
            ITreeEntity entity = (ITreeEntity)element;
            try {
                if (this.searchString.startsWith("all") || this.searchString.startsWith(entity.getKeyWord())) {
                    if (this.entityProvider.getChildren(element) != null) {
                        Object[] objectArray = this.entityProvider.getChildren(element);
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object child = objectArray[n2];
                            if (child != null) {
                                returnValue |= this.select(viewer, element, child);
                            }
                            ++n2;
                        }
                    }
                    return returnValue;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean searchElement(Object element) {
        try {
            Map.Entry<String, String> entry;
            String keyword;
            ITreeEntity entity = (ITreeEntity)element;
            String keyWord = entity.getKeyWord() + ":";
            String regex = "^" + keyWord + ".*$";
            String keyWordAll = "all:";
            String regexKeyWordAll = "^" + keyWordAll + ".*$";
            String contentString = this.searchString.trim();
            if (!this.searchString.matches(regex) && !this.searchString.matches(regexKeyWordAll)) return false;
            contentString = this.searchString.matches(regex) ? contentString.substring(keyWord.length()).trim() : contentString.substring(keyWordAll.length()).trim();
            if (contentString.isEmpty()) {
                return true;
            }
            if (entity.getText().toLowerCase().contains(contentString.toLowerCase())) {
                return true;
            }
            FilterController folderController = FilterController.getInstance();
            List keywordList = folderController.getDefaultKeywords();
            Map<String, String> tagMap = EntityViewerFilter.parseSearchedString(keywordList.toArray(new String[0]), contentString);
            if (tagMap == null || tagMap.isEmpty() || !(entity.getObject() instanceof FileEntity)) return false;
            FileEntity fileEntity = (FileEntity)entity.getObject();
            Iterator<Map.Entry<String, String>> iterator = tagMap.entrySet().iterator();
            do {
                if (!iterator.hasNext()) {
                    return true;
                }
                entry = iterator.next();
                keyword = entry.getKey();
            } while (!folderController.getDefaultKeywords().contains(keyword) || folderController.compare(fileEntity, keyword, entry.getValue()));
            return false;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return false;
    }

    public static Map<String, String> parseSearchedString(String[] searchTags, String contentString) {
        try {
            if (searchTags != null) {
                HashMap<String, String> tagMap = new HashMap<String, String>();
                int i = 0;
                while (i < searchTags.length) {
                    String tagRegex = searchTags[i] + "=\\([^\\)]+\\)";
                    Matcher m = Pattern.compile(tagRegex).matcher(contentString);
                    while (m.find()) {
                        String tagContent = contentString.substring(m.start() + searchTags[i].length() + 2, m.end() - 1);
                        tagMap.put(searchTags[i], tagContent);
                    }
                    ++i;
                }
                return tagMap;
            }
            return null;
        }
        catch (Exception e) {
            LoggerSingleton.getInstance().getLogger().error((Throwable)e);
            return null;
        }
    }
}

