/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.table;

import com.kms.katalon.composer.components.impl.table.CustomColumn;
import com.kms.katalon.composer.components.impl.table.CustomColumnType;
import com.kms.katalon.composer.components.impl.util.CommonInterfaces;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Listener;

public class ColumnBuilder<ItemType, ColumnType> {
    private CustomColumn<ItemType, ColumnType> column;

    public ColumnBuilder(CustomColumn<ItemType, ColumnType> column) {
        this.column = column;
    }

    public static <ItemType, ColumnType> ColumnBuilder<ItemType, ColumnType> create() {
        return new ColumnBuilder(new CustomColumn());
    }

    public ColumnBuilder<ItemType, ColumnType> headerName(String headerName) {
        this.column.headerName = headerName;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> field(String field) {
        this.column.field = field;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> getter(CommonInterfaces.Getter<ItemType, Object> getter) {
        this.column.getter = getter;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> setter(CommonInterfaces.Setter<ItemType, Object> setter) {
        this.column.setter = setter;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> type(Class type) {
        this.column.type = type;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> cellType(CustomColumnType cellType) {
        this.column.cellType = cellType;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> cellType(CommonInterfaces.ColumnTypeProvider<ItemType> cellTypeProvider) {
        this.column.cellTypeProvider = cellTypeProvider;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> renderCell(CommonInterfaces.CellRenderer<ItemType, ColumnType> cellRenderer) {
        this.column.cellRenderer = cellRenderer;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> options(ColumnType ... options) {
        this.column.options = Arrays.asList(options);
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> options(List<ColumnType> options) {
        this.column.options = options;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> readonly() {
        return this.editable(false);
    }

    public ColumnBuilder<ItemType, ColumnType> editable() {
        return this.editable(true);
    }

    public ColumnBuilder<ItemType, ColumnType> editable(boolean editable) {
        this.column.editable = editable;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> editable(CommonInterfaces.Getter<ItemType, Boolean> editableProvider) {
        this.column.editableProvider = editableProvider;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> editorType(CustomColumnType editorType) {
        this.column.editorType = editorType;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> editorType(CommonInterfaces.ColumnTypeProvider<ItemType> typeProvider) {
        this.column.editorTypeProvider = typeProvider;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> renderEditor(CommonInterfaces.EditorRenderer editorRenderer) {
        this.column.editorRenderer = editorRenderer;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> disabled(boolean disabled) {
        this.column.disabled = disabled;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> disabled(CommonInterfaces.Getter<ItemType, Boolean> disabledProvider) {
        this.column.disabledProvider = disabledProvider;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> color(Color color) {
        this.column.color = color;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> colorProvider(CommonInterfaces.Getter<ItemType, Color> colorProvider) {
        this.column.colorProvider = colorProvider;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> on(int event, Listener listener) {
        Set<Object> listeners;
        if (this.column.listeners == null) {
            this.column.listeners = new HashMap<Integer, Set<Listener>>();
        }
        if (this.column.listeners.containsKey(event)) {
            listeners = this.column.listeners.get(event);
        } else {
            listeners = new HashSet();
            this.column.listeners.put(event, listeners);
        }
        listeners.add(listener);
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> cursorType(int cursorType) {
        this.column.cursorType = cursorType;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> width(String width) {
        this.column.width = width;
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> width(int width) {
        this.column.width = String.valueOf(width);
        return this;
    }

    public ColumnBuilder<ItemType, ColumnType> align(int align) {
        this.column.align = align;
        return this;
    }

    public CustomColumn<ItemType, ColumnType> build() {
        return this.column;
    }
}

