/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.tree;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.transfer.TreeEntityTransfer;
import com.kms.katalon.composer.components.impl.tree.AbstractTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.tree.TooltipPropertyDescription;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;

public class TestCaseTreeEntity
extends AbstractTreeEntity {
    private static final long serialVersionUID = 4448626929311619089L;
    private static final String TEST_CASE_TYPE_NAME = StringConstants.TREE_TEST_CASE_TYPE_NAME;
    public static final String KEY_WORD = "tc";
    public static final String[] SEARCH_TAGS = new String[]{"id", "name", "tag", "comment", "description"};
    private TestCaseEntity testCase;

    public TestCaseTreeEntity(TestCaseEntity testCase, ITreeEntity parentTreeEntity) {
        super((FileEntity)testCase, parentTreeEntity);
        this.testCase = testCase;
    }

    public TestCaseEntity getObject() throws Exception {
        TestCaseController.getInstance().reloadTestCase(this.testCase, (Entity)this.entity);
        this.loadAllDescentdantEntities();
        return this.testCase;
    }

    public Object[] getChildren() throws Exception {
        return null;
    }

    public boolean hasChildren() throws Exception {
        return false;
    }

    public Image getImage() throws Exception {
        if (this.testCase.isKatalonAITestCase()) {
            return ImageConstants.IMG_16_TEST_CASE_AI_GEN;
        }
        return ImageConstants.IMG_16_TEST_CASE;
    }

    public String getTypeName() throws Exception {
        return TEST_CASE_TYPE_NAME;
    }

    public boolean isRemoveable() throws Exception {
        return true;
    }

    public boolean isRenamable() throws Exception {
        return true;
    }

    public Transfer getEntityTransfer() throws Exception {
        return TreeEntityTransfer.getInstance();
    }

    public String getCopyTag() throws Exception {
        return FolderEntity.FolderType.TESTCASE.toString();
    }

    public String getKeyWord() throws Exception {
        return KEY_WORD;
    }

    public String[] getSearchTags() throws Exception {
        return SEARCH_TAGS;
    }

    public String getPropertyValue(String key) {
        if (key.equals("id")) {
            return this.testCase.getIdForDisplay();
        }
        if (key.equals("name")) {
            return this.testCase.getName();
        }
        if (key.equals("tag")) {
            return this.testCase.getTag();
        }
        if (key.equals("comment")) {
            return this.testCase.getComment();
        }
        if (key.equals("description")) {
            return this.testCase.getDescription();
        }
        return "";
    }

    public Image getEntryImage() throws Exception {
        return this.getImage();
    }

    @Override
    public void setObject(Object object) throws Exception {
        if (object instanceof TestCaseEntity) {
            this.entity = (FileEntity)object;
            this.testCase = (TestCaseEntity)object;
        }
    }

    public void loadAllDescentdantEntities() throws Exception {
        TestCaseController.getInstance().loadAllDescentdantEntities(this.testCase);
    }

    @Override
    public List<TooltipPropertyDescription> getTooltipDescriptions() {
        List<TooltipPropertyDescription> properties = super.getTooltipDescriptions();
        properties.add(TooltipPropertyDescription.createWithDefaultLength((String)StringConstants.TAG, (String)this.testCase.getTag()));
        return properties;
    }

    public String getObjecParentPathDir() {
        if (this.testCase.getTag() != null && this.testCase.isAPITestGenerationTestCase()) {
            String parentPath = this.testCase.getParentFolder().getLocation() + File.separator;
            return parentPath;
        }
        return super.getObjecParentPathDir();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestCaseTreeEntity other = (TestCaseTreeEntity)obj;
        return Objects.equals(this.testCase, other.testCase);
    }
}

