/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.util;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.QueryBuilder;

public class EntityIndexingUtil {
    public static final String LUCENE_DIR_LOCATION = ProjectController.getInstance().getTempDir() + File.separator + "plugins" + File.separator + "lucene_8" + File.separator;
    public static final String FIELD_ID = "id";
    public static final String FIELD_TYPE = "type";
    private IndexWriterConfig indexWriterConfig;
    private IndexWriter writer;
    private DirectoryReader reader;
    private IndexSearcher searcher;
    private QueryBuilder queryParser;
    private String indexDirLocation;
    private String projectDirLocation;
    private Directory indexDir;
    private Sort sort;
    private static EntityIndexingUtil instance;

    private EntityIndexingUtil(String indexDirLocation, String projectDirLocation) throws IOException {
        this.indexDirLocation = indexDirLocation;
        this.projectDirLocation = projectDirLocation;
        this.indexDir = FSDirectory.open((Path)Paths.get(indexDirLocation, new String[0]));
        this.sort = new Sort(new SortField[]{new SortField(FIELD_ID, SortField.Type.STRING)});
    }

    private void loadIndexReader() throws IOException {
        this.reader = DirectoryReader.open((Directory)this.indexDir);
        this.searcher = new IndexSearcher((IndexReader)this.reader);
        if (this.queryParser == null) {
            this.queryParser = new QueryBuilder((Analyzer)new StandardAnalyzer());
        }
    }

    private void loadIndexWriter() throws IOException {
        this.indexWriterConfig = new IndexWriterConfig().setIndexSort(this.sort);
        try {
            this.writer = new IndexWriter(this.indexDir, this.indexWriterConfig);
        }
        catch (IndexFormatTooOldException indexFormatTooOldException) {
            FileUtils.cleanDirectory((File)new File(LUCENE_DIR_LOCATION));
            this.loadIndexWriter();
        }
    }

    public static EntityIndexingUtil getInstance(ProjectEntity project) throws IOException {
        String indexDirLocation = LUCENE_DIR_LOCATION + project.getUUID();
        if (instance == null || !StringUtils.equals((String)indexDirLocation, (String)instance.getIndexDirLocation())) {
            instance = new EntityIndexingUtil(indexDirLocation, project.getFolderLocation());
        }
        return instance;
    }

    public String getIndexDirLocation() {
        return this.indexDirLocation;
    }

    public List<String> getIndexedEntityIds(String entityExtension) {
        try {
            List<String> ids;
            this.loadIndexReader();
            TopDocs topdocs = this.search(entityExtension);
            if (topdocs == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            ScoreDoc[] scoreDocs = topdocs.scoreDocs;
            if (scoreDocs == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            List<String> list = ids = Arrays.asList(scoreDocs).parallelStream().filter(scoreDoc -> this.isValidScoreDoc((ScoreDoc)scoreDoc)).map(scoreDoc -> this.getIndexedEntityID((ScoreDoc)scoreDoc)).filter(id -> id != null).sorted().collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private boolean isValidScoreDoc(ScoreDoc scoreDoc) {
        try {
            return scoreDoc != null && this.searcher.doc(scoreDoc.doc) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private String getIndexedEntityID(ScoreDoc scoreDoc) {
        try {
            return this.searcher.doc(scoreDoc.doc).get(FIELD_ID);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int doIndex() {
        try {
            this.loadIndexWriter();
            this.writer.deleteAll();
            this.indexDir(this.projectDirLocation, new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String name = file.getName().toLowerCase();
                    return name.endsWith(TestCaseEntity.getTestCaseFileExtension()) || name.endsWith(TestSuiteEntity.getTestSuiteFileExtension()) || name.endsWith(CheckpointEntity.getCheckpointFileExtension()) || name.endsWith(DataFileEntity.getTestDataFileExtension()) || name.endsWith(WebElementEntity.getWebElementFileExtension());
                }
            });
            int n = this.writer.numRamDocs();
            return n;
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return -1;
        }
        finally {
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private void indexDir(String dataDirPath, FileFilter filter) {
        Arrays.asList(new File(dataDirPath).listFiles()).parallelStream().filter(item -> !item.isHidden() && item.exists() && item.canRead()).forEach(item -> {
            if (item.isDirectory()) {
                this.indexDir(item.getAbsolutePath(), filter);
                return;
            }
            if (filter.accept((File)item)) {
                this.indexFile((File)item);
            }
        });
    }

    private void indexFile(File file) {
        try {
            this.writer.addDocument((Iterable)this.createIndexDocument(file));
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private Document createIndexDocument(File file) {
        Document document = new Document();
        document.add((IndexableField)new Field(FIELD_ID, (CharSequence)this.getEntityID(file), (IndexableFieldType)TextField.TYPE_STORED));
        document.add((IndexableField)new Field(FIELD_TYPE, (CharSequence)FilenameUtils.getExtension((String)file.getName()), (IndexableFieldType)TextField.TYPE_STORED));
        document.add((IndexableField)new SortedDocValuesField(FIELD_ID, new BytesRef((CharSequence)this.getEntityID(file))));
        return document;
    }

    private String getEntityID(File file) {
        String id = FilenameUtils.removeExtension((String)file.getAbsolutePath());
        id = StringUtils.removeStart((String)id, (String)(ProjectController.getInstance().getCurrentProject().getFolderLocation() + File.separator));
        id = FilenameUtils.separatorsToUnix((String)id);
        return id;
    }

    private TopDocs search(String searchQuery) throws IOException {
        Query query = this.queryParser.createBooleanQuery(FIELD_TYPE, searchQuery);
        int maxDoc = this.reader.maxDoc();
        if (maxDoc <= 0) {
            return null;
        }
        return this.searcher.search(query, maxDoc);
    }
}

