/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.plugins.storage;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import org.openqa.selenium.remote.http.WebSocket;

public class StorageUtils {
    private static final int BUFFER_SIZE = 65535;

    private StorageUtils() {
    }

    public static String calcSha1Digest(File source) {
        MessageDigest sha1sum;
        try {
            sha1sum = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        byte[] buffer = new byte[65535];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));){
            int bytesRead;
            while ((bytesRead = in.read(buffer)) != -1) {
                sha1sum.update(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return StorageUtils.byteToHex(sha1sum.digest());
    }

    public static void streamFileToWebSocket(File source, WebSocket socket) {
        byte[] buffer = new byte[65535];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));){
            int bytesRead;
            while ((bytesRead = in.read(buffer)) != -1) {
                byte[] currentBuffer = new byte[bytesRead];
                System.arraycopy(buffer, 0, currentBuffer, 0, bytesRead);
                socket.sendBinary(currentBuffer);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }
}

