/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.codehaus.groovy.eclipse.dsl.DSLDStore;
import org.codehaus.groovy.eclipse.dsl.RefreshDSLDJob;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;

public class DSLDStoreManager {
    private final Map<String, DSLDStore> dsldStores = new ConcurrentHashMap<String, DSLDStore>();
    private final Set<String> inProgress = new ConcurrentSkipListSet<String>();
    private final Object progressMonitor = new Object();

    public String[] getProjectNames() {
        return this.dsldStores.keySet().toArray(new String[this.dsldStores.size()]);
    }

    public DSLDStore getDSLDStore(IProject project) {
        return this.dsldStores.computeIfAbsent(project.getName(), projectName -> new DSLDStore());
    }

    public boolean hasDSLDStoreFor(IProject project) {
        return this.dsldStores.containsKey(project.getName());
    }

    public void removeDSLDStore(IProject project) {
        this.dsldStores.remove(project.getName());
    }

    public void reset() {
        this.dsldStores.clear();
    }

    public void initialize(IProject project, boolean synchronous) {
        this.initialize(Collections.singletonList(project), synchronous);
    }

    public void initialize(IProject[] projects, boolean synchronous) {
        this.initialize(Arrays.asList(projects), synchronous);
    }

    public void initialize(Collection<IProject> projects, boolean synchronous) {
        List<IProject> groovyProjects = projects.stream().filter(GroovyNature::hasGroovyNature).collect(Collectors.toList());
        if (!groovyProjects.isEmpty()) {
            RefreshDSLDJob refreshJob = new RefreshDSLDJob(groovyProjects);
            refreshJob.setPriority(synchronous ? 10 : 30);
            refreshJob.schedule();
            if (synchronous) {
                this.waitForFinish();
            }
        }
    }

    public void ensureInitialized(IProject project, boolean synchronous) {
        boolean isInProgress = this.isInProgress(project);
        if (!isInProgress && !this.hasDSLDStoreFor(project)) {
            this.initialize(project, synchronous);
        } else if (isInProgress && synchronous) {
            this.waitForFinish();
        }
    }

    private boolean isInProgress(IProject project) {
        return this.inProgress.contains(project.getName());
    }

    private boolean addInProgress(IProject project) {
        return this.inProgress.add(project.getName());
    }

    List<IProject> addInProgress(Collection<IProject> projects) {
        return projects.stream().filter(this::addInProgress).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInProgress(IProject project) {
        this.inProgress.remove(project.getName());
        Object object = this.progressMonitor;
        synchronized (object) {
            this.progressMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFinish() {
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        while (!this.inProgress.isEmpty()) {
            long timeLeft = end - System.currentTimeMillis();
            if (timeLeft <= 0L) break;
            Object object = this.progressMonitor;
            synchronized (object) {
                try {
                    this.progressMonitor.wait(Math.min(timeLeft, 100L));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

