/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.contributions;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyPropertyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.dsl.contributions.ContributionElems;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionElement;
import org.codehaus.groovy.eclipse.dsl.lookup.ResolverCache;
import org.eclipse.jdt.groovy.search.AbstractSimplifiedTypeLookup;
import org.eclipse.jdt.groovy.search.VariableScope;

public class PropertyContributionElement
implements IContributionElement {
    private final String propName;
    private final String propType;
    private final String declaringType;
    private final int modifiers;
    private final int relevanceMultiplier;
    private ClassNode cachedDeclaringType;
    private ClassNode cachedType;
    private final String provider;
    private final String doc;

    public PropertyContributionElement(String propName, String propType, String declaringType, int modifiers, String provider, String doc, boolean isDeprecated, int relevanceMultiplier) {
        this.propName = propName;
        this.propType = propType;
        this.declaringType = declaringType;
        this.modifiers = modifiers & 0xF8 | (isDeprecated ? 0x100000 : 0);
        this.relevanceMultiplier = relevanceMultiplier;
        String string = this.provider = provider != null ? ContributionElems.removeJavadocMarkup(provider) : "DSL Descriptor";
        this.doc = doc != null ? doc : "Provided by " + (provider != null ? provider : "DSL Descriptor");
    }

    @Override
    public AbstractSimplifiedTypeLookup.TypeAndDeclaration resolve(String name, ClassNode declaringType, ResolverCache resolver, VariableScope scope) {
        if (name.equals(this.propName)) {
            return new AbstractSimplifiedTypeLookup.TypeAndDeclaration(this.returnType(resolver), (ASTNode)this.toProperty(declaringType, resolver), this.declaringType(declaringType, resolver), this.doc);
        }
        return null;
    }

    @Override
    public IGroovyProposal toProposal(ClassNode declaringType, ResolverCache resolver) {
        GroovyPropertyProposal proposal = new GroovyPropertyProposal(this.toProperty(declaringType, resolver), this.provider);
        proposal.setRelevanceMultiplier((float)this.relevanceMultiplier);
        return proposal;
    }

    @Override
    public List<IGroovyProposal> extraProposals(ClassNode declaringType, ResolverCache resolver, Expression enclosingExpression) {
        return ProposalUtils.NO_PROPOSALS;
    }

    private PropertyNode toProperty(ClassNode declaringType, ResolverCache resolver) {
        ClassNode resolvedDeclaringType = this.declaringType(declaringType, resolver);
        FieldNode backingField = new FieldNode(this.propName, 2 | this.modifiers, this.returnType(resolver), resolvedDeclaringType, null);
        backingField.setDeclaringClass(resolvedDeclaringType);
        PropertyNode property = new PropertyNode(backingField, 1 | this.modifiers, null, null);
        property.setDeclaringClass(resolvedDeclaringType);
        return property;
    }

    protected ClassNode returnType(ResolverCache resolver) {
        if (this.cachedType == null) {
            this.cachedType = resolver.resolve(this.propType);
        }
        return this.cachedType == null ? ClassHelper.dynamicType() : this.cachedType;
    }

    protected ClassNode declaringType(ClassNode lexicalDeclaringType, ResolverCache resolver) {
        if (this.declaringType != null && this.cachedDeclaringType == null) {
            this.cachedDeclaringType = resolver.resolve(this.declaringType);
        }
        return this.cachedDeclaringType == null ? lexicalDeclaringType : this.cachedDeclaringType;
    }

    @Override
    public String getContributionName() {
        return this.propName;
    }

    @Override
    public String description() {
        return "Property: " + this.declaringType + "." + this.propName;
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("public ");
        if ((this.modifiers & 8) != 0) {
            sb.append("static ");
        }
        if ((this.modifiers & 0x10) != 0) {
            sb.append("final ");
        }
        sb.append(this.propType);
        sb.append(' ');
        sb.append(this.declaringType);
        sb.append('.');
        sb.append(this.propName);
        sb.append(" (");
        sb.append(this.provider);
        sb.append(')');
        return sb.toString();
    }
}

