/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions;

import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.AbstractJavaTypeVerifiedRule;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ValueStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;

public class JavaValidTypeRule
extends AbstractJavaTypeVerifiedRule {
    public JavaValidTypeRule(IJavaProject project) {
        super(project);
    }

    @Override
    public ValueStatus checkValidity(Object value) {
        if (value instanceof String) {
            String name = (String)value;
            IStatus status = JavaConventions.validateJavaTypeName((String)name, (String)"1.3", (String)"1.3");
            if (status.getSeverity() != 4) {
                try {
                    IType type = this.getActualType(name);
                    if (type != null) {
                        return ValueStatus.getValidStatus(value);
                    }
                    return ValueStatus.getErrorStatus(value, "The specified Java type(s) does not exist: " + name);
                }
                catch (JavaModelException e) {
                    GroovyDSLCoreActivator.logException(e);
                }
            } else {
                return ValueStatus.getErrorStatus(value, "Invalid Java type.");
            }
        }
        return ValueStatus.getErrorStatus(value, "Invalid Java type.");
    }
}

