/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.writer;

import java.lang.reflect.InvocationTargetException;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.InferencingSuggestionsManager;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.writer.SuggestionsFileProperties;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateFileOperation;

public class SuggestionsFile {
    private IProject project;
    private SuggestionsFileProperties location;

    public SuggestionsFile(IProject project) {
        this.project = project;
        this.location = new SuggestionsFileProperties();
    }

    public IProject getProject() {
        return this.project;
    }

    public IFile createFile() {
        String path = this.getPath();
        if (path != null) {
            IFile suggestionsFile = this.project.getFile(path);
            if (!suggestionsFile.exists()) {
                suggestionsFile = this.createNewFile(suggestionsFile);
            }
            return suggestionsFile != null && suggestionsFile.exists() ? suggestionsFile : null;
        }
        return null;
    }

    protected String getPath() {
        return InferencingSuggestionsManager.getInstance().isValidProject(this.project) && this.location != null ? this.location.getWritingLocation() + this.location.getFileName() + "." + this.location.getFileType() : null;
    }

    public IFile getFile() {
        String path = this.getPath();
        if (path != null) {
            IFile suggestionsFile = this.project.getFile(path);
            return suggestionsFile != null && suggestionsFile.exists() ? suggestionsFile : null;
        }
        return null;
    }

    protected IFile createNewFile(IFile fileHandle) {
        IWorkbench workBench = PlatformUI.getWorkbench();
        if (workBench == null || fileHandle.exists()) {
            return null;
        }
        IWorkbenchWindow runnableContext = workBench.getActiveWorkbenchWindow();
        IFile newFile = fileHandle;
        IRunnableWithProgress op = monitor -> {
            CreateFileOperation op1 = new CreateFileOperation(newFile, null, null, "Creating Suggestions File");
            try {
                op1.execute(monitor, null);
            }
            catch (ExecutionException e) {
                GroovyDSLCoreActivator.logException(e);
            }
        };
        try {
            runnableContext.run(true, true, op);
            newFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException | InvocationTargetException | CoreException e) {
            GroovyDSLCoreActivator.logException(e);
            return null;
        }
        return newFile;
    }
}

