/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.Collection;
import java.util.Collections;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.eclipse.dsl.pointcuts.AbstractPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.eclipse.core.resources.IStorage;

public class CurrentTypePointcut
extends AbstractPointcut {
    public CurrentTypePointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName);
    }

    @Override
    public Collection<?> matches(GroovyDSLDContext pattern, Object toMatch) {
        ClassNode currentType = pattern.getCurrentType();
        if (currentType != null) {
            Object firstArgument = this.getFirstArgument();
            if (firstArgument instanceof String) {
                if (currentType.getName().equals(firstArgument)) {
                    return Collections.singleton(currentType);
                }
            } else if (firstArgument instanceof Class) {
                if (currentType.getName().equals(((Class)firstArgument).getName())) {
                    return Collections.singleton(currentType);
                }
            } else {
                if (firstArgument != null) {
                    return this.matchOnPointcutArgument((IPointcut)firstArgument, pattern, Collections.singleton(currentType));
                }
                return Collections.singleton(currentType);
            }
        }
        return null;
    }

    @Override
    public void verify() throws PointcutVerificationException {
        String oneClassOrStringOrPointcutArg = this.oneStringOrOnePointcutOrOneClassArg();
        String oneOrNone = this.hasOneOrNoArgs();
        if (oneClassOrStringOrPointcutArg == null || oneOrNone == null) {
            super.verify();
            return;
        }
        throw new PointcutVerificationException("This pointcut expects either 0 arguments or 1 argument of type Pointcut or String or Class", this);
    }
}

