/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.Collection;
import java.util.Collections;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.eclipse.dsl.pointcuts.AbstractPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.eclipse.core.resources.IStorage;

public class EnclosingMethodPointcut
extends AbstractPointcut {
    public EnclosingMethodPointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName);
    }

    @Override
    public Collection<?> matches(GroovyDSLDContext pattern, Object toMatch) {
        MethodNode enclosing = pattern.getCurrentScope().getEnclosingMethodDeclaration();
        if (enclosing != null) {
            Object argument = this.getFirstArgument();
            if (argument instanceof String) {
                if (argument.equals(enclosing.getName())) {
                    return Collections.singleton(enclosing);
                }
            } else {
                return this.matchOnPointcutArgument((IPointcut)argument, pattern, Collections.singleton(enclosing));
            }
        }
        return null;
    }

    @Override
    public void verify() throws PointcutVerificationException {
        String failure = this.oneStringOrOnePointcutArg();
        if (failure != null) {
            throw new PointcutVerificationException(failure, this);
        }
        super.verify();
    }
}

