/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.FilteringPointcut;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;

public abstract class FindASTPointcut<T extends ASTNode>
extends FilteringPointcut<T> {
    private final Function<ClassNode, ? extends Collection<T>> exploder;
    private final Function<T, String> stringify;

    public FindASTPointcut(IStorage containerIdentifier, String pointcutName, Class<T> filterBy, Function<ClassNode, ? extends Collection<T>> exploder, Function<T, String> stringify) {
        super(containerIdentifier, pointcutName, filterBy);
        this.exploder = Objects.requireNonNull(exploder);
        this.stringify = Objects.requireNonNull(stringify);
    }

    @Override
    protected final Collection<T> explodeObject(Object object) {
        ArrayList result = new ArrayList();
        this.explodeObject(object, result);
        return result;
    }

    protected void explodeObject(Object object, Collection<T> result) {
        if (this.filterBy.isInstance(object)) {
            ASTNode node = (ASTNode)object;
            result.add(node);
        } else if (object instanceof ClassNode) {
            result.addAll(this.exploder.apply(GroovyUtils.getWrapperTypeIfPrimitive((ClassNode)((ClassNode)object))));
        } else if (object instanceof Collection) {
            ((Collection)object).forEach(item -> this.explodeObject(item, result));
        }
    }

    @Override
    protected T filterObject(T result, GroovyDSLDContext context, String firstArgAsString) {
        if (firstArgAsString == null || firstArgAsString.equals(this.stringify.apply(result))) {
            return result;
        }
        return null;
    }
}

