/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios.xcode.parser.models;

import ca.mestevens.ios.xcode.parser.exceptions.InvalidObjectFormatException;
import ca.mestevens.ios.xcode.parser.models.CommentedIdentifier;
import ca.mestevens.ios.xcode.parser.utils.ObjectParser;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBXBuildPhase
implements Comparable<PBXBuildPhase> {
    private CommentedIdentifier reference;
    private String isa;
    private Integer buildActionMask;
    private List<CommentedIdentifier> files;
    private Integer runOnlyForDeploymentPostprocessing;
    private String name;
    private String dstPath;
    private Integer dstSubfolderSpec;
    private List<String> inputPaths;
    private List<String> outputPaths;
    private String shellPath;
    private String shellScript;

    public PBXBuildPhase(String isa, String name, List<CommentedIdentifier> files) {
        this.reference = new CommentedIdentifier(UUID.randomUUID().toString(), name);
        this.isa = isa;
        this.name = name;
        this.buildActionMask = Integer.MAX_VALUE;
        this.files = files != null ? files : new ArrayList<CommentedIdentifier>();
        this.runOnlyForDeploymentPostprocessing = 0;
    }

    public PBXBuildPhase(String isa, String name, List<String> inputPaths, List<String> outputPaths, String shellPath, String shellScript) {
        this(isa, name, null);
        this.inputPaths = inputPaths;
        this.outputPaths = outputPaths;
        this.shellPath = shellPath;
        this.shellScript = shellScript;
    }

    public PBXBuildPhase(String isa, String name, List<CommentedIdentifier> files, String dstPath, Integer dstSubfolderSpec) {
        this(isa, name, files);
        this.dstPath = dstPath;
        this.dstSubfolderSpec = dstSubfolderSpec;
    }

    public PBXBuildPhase(String buildPhaseString) throws InvalidObjectFormatException {
        try {
            buildPhaseString = buildPhaseString.trim();
            int equalsIndex = buildPhaseString.indexOf(61);
            String commentPart = "";
            String uuidPart = buildPhaseString.substring(0, equalsIndex).trim();
            if (uuidPart.contains("/*")) {
                int commentStartIndex = uuidPart.indexOf("/*");
                int commentEndIndex = uuidPart.indexOf("*/");
                commentPart = buildPhaseString.substring(commentStartIndex + 2, commentEndIndex).trim();
                uuidPart = uuidPart.substring(0, commentStartIndex).trim();
            }
            this.reference = new CommentedIdentifier(uuidPart, commentPart);
            ObjectParser parser = new ObjectParser(buildPhaseString);
            parser = parser.getNextNestedObjects();
            String parserObject = parser.parseNextObject();
            while (parserObject != null) {
                parserObject = parserObject.substring(0, parserObject.length() - 1);
                String[] splitObject = parserObject.split("=");
                String key = splitObject[0].trim();
                String value = "";
                for (int i = 1; i < splitObject.length; ++i) {
                    if (i > 1) {
                        value = value + "=";
                    }
                    value = value + splitObject[i];
                }
                value = value.trim();
                if (key.equals("isa")) {
                    this.isa = value;
                } else if (key.equals("buildActionMask")) {
                    this.buildActionMask = Integer.parseInt(value);
                } else if (key.equals("files")) {
                    this.files = parser.getIdentifierList(value);
                } else if (key.equals("runOnlyForDeploymentPostprocessing")) {
                    this.runOnlyForDeploymentPostprocessing = Integer.parseInt(value);
                } else if (key.equals("dstPath")) {
                    this.dstPath = value;
                } else if (key.equals("dstSubfolderSpec")) {
                    this.dstSubfolderSpec = Integer.parseInt(value);
                } else if (key.equals("inputPaths")) {
                    this.inputPaths = parser.getStringList(value);
                } else if (key.equals("outputPaths")) {
                    this.outputPaths = parser.getStringList(value);
                } else if (key.equals("shellPath")) {
                    this.shellPath = value;
                } else if (key.equals("shellScript")) {
                    this.shellScript = value;
                } else if (key.equals("name")) {
                    this.name = value;
                }
                parserObject = parser.parseNextObject();
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectFormatException(ex);
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int numberOfTabs) {
        String tabString = "";
        for (int i = 0; i < numberOfTabs; ++i) {
            tabString = tabString + "\t";
        }
        String returnString = tabString + this.reference.toString() + " = {\n";
        returnString = returnString + tabString + "\tisa = " + this.isa + ";\n";
        returnString = returnString + tabString + "\tbuildActionMask = " + this.buildActionMask + ";\n";
        if (this.dstPath != null) {
            returnString = returnString + tabString + "\tdstPath = " + this.dstPath + ";\n";
        }
        if (this.dstSubfolderSpec != null) {
            returnString = returnString + tabString + "\tdstSubfolderSpec = " + this.dstSubfolderSpec + ";\n";
        }
        returnString = returnString + tabString + "\tfiles = (\n";
        for (CommentedIdentifier file : this.files) {
            returnString = returnString + tabString + "\t\t" + file.toString() + ",\n";
        }
        returnString = returnString + tabString + "\t);\n";
        if (this.inputPaths != null) {
            returnString = returnString + tabString + "\tinputPaths = (\n";
            for (String inputPath : this.inputPaths) {
                returnString = returnString + tabString + "\t\t" + inputPath + ",\n";
            }
            returnString = returnString + tabString + "\t);\n";
        }
        if (this.name != null) {
            returnString = returnString + tabString + "\tname = " + this.name + ";\n";
        }
        if (this.outputPaths != null) {
            returnString = returnString + tabString + "\toutputPaths = (\n";
            for (String outputPath : this.outputPaths) {
                returnString = returnString + tabString + "\t\t" + outputPath + ",\n";
            }
            returnString = returnString + tabString + "\t);\n";
        }
        returnString = returnString + tabString + "\trunOnlyForDeploymentPostprocessing = " + this.runOnlyForDeploymentPostprocessing + ";\n";
        if (this.shellPath != null) {
            returnString = returnString + tabString + "\tshellPath = " + this.shellPath + ";\n";
        }
        if (this.shellScript != null) {
            returnString = returnString + tabString + "\tshellScript = " + this.shellScript + ";\n";
        }
        returnString = returnString + tabString + "};";
        return returnString;
    }

    @Override
    public int compareTo(PBXBuildPhase o) {
        return this.reference.getIdentifier().compareTo(o.reference.getIdentifier());
    }

    public CommentedIdentifier getReference() {
        return this.reference;
    }

    public String getIsa() {
        return this.isa;
    }

    public Integer getBuildActionMask() {
        return this.buildActionMask;
    }

    public List<CommentedIdentifier> getFiles() {
        return this.files;
    }

    public Integer getRunOnlyForDeploymentPostprocessing() {
        return this.runOnlyForDeploymentPostprocessing;
    }

    public String getName() {
        return this.name;
    }

    public String getDstPath() {
        return this.dstPath;
    }

    public Integer getDstSubfolderSpec() {
        return this.dstSubfolderSpec;
    }

    public List<String> getInputPaths() {
        return this.inputPaths;
    }

    public List<String> getOutputPaths() {
        return this.outputPaths;
    }

    public String getShellPath() {
        return this.shellPath;
    }

    public String getShellScript() {
        return this.shellScript;
    }

    public void setReference(CommentedIdentifier reference) {
        this.reference = reference;
    }

    public void setIsa(String isa) {
        this.isa = isa;
    }

    public void setBuildActionMask(Integer buildActionMask) {
        this.buildActionMask = buildActionMask;
    }

    public void setFiles(List<CommentedIdentifier> files) {
        this.files = files;
    }

    public void setRunOnlyForDeploymentPostprocessing(Integer runOnlyForDeploymentPostprocessing) {
        this.runOnlyForDeploymentPostprocessing = runOnlyForDeploymentPostprocessing;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDstPath(String dstPath) {
        this.dstPath = dstPath;
    }

    public void setDstSubfolderSpec(Integer dstSubfolderSpec) {
        this.dstSubfolderSpec = dstSubfolderSpec;
    }

    public void setInputPaths(List<String> inputPaths) {
        this.inputPaths = inputPaths;
    }

    public void setOutputPaths(List<String> outputPaths) {
        this.outputPaths = outputPaths;
    }

    public void setShellPath(String shellPath) {
        this.shellPath = shellPath;
    }

    public void setShellScript(String shellScript) {
        this.shellScript = shellScript;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PBXBuildPhase)) {
            return false;
        }
        PBXBuildPhase other = (PBXBuildPhase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommentedIdentifier this$reference = this.getReference();
        CommentedIdentifier other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference)) {
            return false;
        }
        String this$isa = this.getIsa();
        String other$isa = other.getIsa();
        if (this$isa == null ? other$isa != null : !this$isa.equals(other$isa)) {
            return false;
        }
        Integer this$buildActionMask = this.getBuildActionMask();
        Integer other$buildActionMask = other.getBuildActionMask();
        if (this$buildActionMask == null ? other$buildActionMask != null : !((Object)this$buildActionMask).equals(other$buildActionMask)) {
            return false;
        }
        List<CommentedIdentifier> this$files = this.getFiles();
        List<CommentedIdentifier> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        Integer this$runOnlyForDeploymentPostprocessing = this.getRunOnlyForDeploymentPostprocessing();
        Integer other$runOnlyForDeploymentPostprocessing = other.getRunOnlyForDeploymentPostprocessing();
        if (this$runOnlyForDeploymentPostprocessing == null ? other$runOnlyForDeploymentPostprocessing != null : !((Object)this$runOnlyForDeploymentPostprocessing).equals(other$runOnlyForDeploymentPostprocessing)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$dstPath = this.getDstPath();
        String other$dstPath = other.getDstPath();
        if (this$dstPath == null ? other$dstPath != null : !this$dstPath.equals(other$dstPath)) {
            return false;
        }
        Integer this$dstSubfolderSpec = this.getDstSubfolderSpec();
        Integer other$dstSubfolderSpec = other.getDstSubfolderSpec();
        if (this$dstSubfolderSpec == null ? other$dstSubfolderSpec != null : !((Object)this$dstSubfolderSpec).equals(other$dstSubfolderSpec)) {
            return false;
        }
        List<String> this$inputPaths = this.getInputPaths();
        List<String> other$inputPaths = other.getInputPaths();
        if (this$inputPaths == null ? other$inputPaths != null : !((Object)this$inputPaths).equals(other$inputPaths)) {
            return false;
        }
        List<String> this$outputPaths = this.getOutputPaths();
        List<String> other$outputPaths = other.getOutputPaths();
        if (this$outputPaths == null ? other$outputPaths != null : !((Object)this$outputPaths).equals(other$outputPaths)) {
            return false;
        }
        String this$shellPath = this.getShellPath();
        String other$shellPath = other.getShellPath();
        if (this$shellPath == null ? other$shellPath != null : !this$shellPath.equals(other$shellPath)) {
            return false;
        }
        String this$shellScript = this.getShellScript();
        String other$shellScript = other.getShellScript();
        return !(this$shellScript == null ? other$shellScript != null : !this$shellScript.equals(other$shellScript));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PBXBuildPhase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommentedIdentifier $reference = this.getReference();
        result = result * 59 + ($reference == null ? 0 : ((Object)$reference).hashCode());
        String $isa = this.getIsa();
        result = result * 59 + ($isa == null ? 0 : $isa.hashCode());
        Integer $buildActionMask = this.getBuildActionMask();
        result = result * 59 + ($buildActionMask == null ? 0 : ((Object)$buildActionMask).hashCode());
        List<CommentedIdentifier> $files = this.getFiles();
        result = result * 59 + ($files == null ? 0 : ((Object)$files).hashCode());
        Integer $runOnlyForDeploymentPostprocessing = this.getRunOnlyForDeploymentPostprocessing();
        result = result * 59 + ($runOnlyForDeploymentPostprocessing == null ? 0 : ((Object)$runOnlyForDeploymentPostprocessing).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        String $dstPath = this.getDstPath();
        result = result * 59 + ($dstPath == null ? 0 : $dstPath.hashCode());
        Integer $dstSubfolderSpec = this.getDstSubfolderSpec();
        result = result * 59 + ($dstSubfolderSpec == null ? 0 : ((Object)$dstSubfolderSpec).hashCode());
        List<String> $inputPaths = this.getInputPaths();
        result = result * 59 + ($inputPaths == null ? 0 : ((Object)$inputPaths).hashCode());
        List<String> $outputPaths = this.getOutputPaths();
        result = result * 59 + ($outputPaths == null ? 0 : ((Object)$outputPaths).hashCode());
        String $shellPath = this.getShellPath();
        result = result * 59 + ($shellPath == null ? 0 : $shellPath.hashCode());
        String $shellScript = this.getShellScript();
        result = result * 59 + ($shellScript == null ? 0 : $shellScript.hashCode());
        return result;
    }

    public PBXBuildPhase() {
    }

    @ConstructorProperties(value={"reference", "isa", "buildActionMask", "files", "runOnlyForDeploymentPostprocessing", "name", "dstPath", "dstSubfolderSpec", "inputPaths", "outputPaths", "shellPath", "shellScript"})
    public PBXBuildPhase(CommentedIdentifier reference, String isa, Integer buildActionMask, List<CommentedIdentifier> files, Integer runOnlyForDeploymentPostprocessing, String name, String dstPath, Integer dstSubfolderSpec, List<String> inputPaths, List<String> outputPaths, String shellPath, String shellScript) {
        this.reference = reference;
        this.isa = isa;
        this.buildActionMask = buildActionMask;
        this.files = files;
        this.runOnlyForDeploymentPostprocessing = runOnlyForDeploymentPostprocessing;
        this.name = name;
        this.dstPath = dstPath;
        this.dstSubfolderSpec = dstSubfolderSpec;
        this.inputPaths = inputPaths;
        this.outputPaths = outputPaths;
        this.shellPath = shellPath;
        this.shellScript = shellScript;
    }
}

