/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios.xcode.parser.models;

import ca.mestevens.ios.xcode.parser.exceptions.InvalidObjectFormatException;
import ca.mestevens.ios.xcode.parser.models.CommentedIdentifier;
import ca.mestevens.ios.xcode.parser.utils.ObjectParser;
import java.beans.ConstructorProperties;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBXFileElement
implements Comparable<PBXFileElement> {
    private CommentedIdentifier reference;
    private String isa;
    private String name;
    private String sourceTree;
    private Integer fileEncoding;
    private Integer includeInIndex;
    private String explicitFileType;
    private String lastKnownFileType;
    private String path;
    private List<CommentedIdentifier> children;

    public PBXFileElement(String filePath, String sourceTree) {
        Path path = Paths.get(filePath, new String[0]);
        this.name = path.getFileName().toString();
        this.reference = new CommentedIdentifier(UUID.randomUUID().toString(), this.name);
        this.isa = "PBXFileReference";
        this.path = path.toString();
        this.sourceTree = sourceTree;
    }

    public PBXFileElement(String isa, String name, String sourceTree) {
        this.name = name;
        this.isa = isa;
        this.sourceTree = sourceTree;
        this.reference = new CommentedIdentifier(UUID.randomUUID().toString(), this.name);
        this.children = new ArrayList<CommentedIdentifier>();
    }

    public PBXFileElement(String fileElementString) throws InvalidObjectFormatException {
        try {
            fileElementString = fileElementString.trim();
            int equalsIndex = fileElementString.indexOf(61);
            String commentPart = "";
            String uuidPart = fileElementString.substring(0, equalsIndex).trim();
            if (uuidPart.contains("/*")) {
                int commentStartIndex = uuidPart.indexOf("/*");
                int commentEndIndex = uuidPart.indexOf("*/");
                commentPart = fileElementString.substring(commentStartIndex + 2, commentEndIndex).trim();
                uuidPart = uuidPart.substring(0, commentStartIndex).trim();
            }
            this.reference = new CommentedIdentifier(uuidPart, commentPart);
            ObjectParser parser = new ObjectParser(fileElementString);
            parser = parser.getNextNestedObjects();
            String parserObject = parser.parseNextObject();
            while (parserObject != null) {
                parserObject = parserObject.substring(0, parserObject.length() - 1);
                String[] splitObject = parserObject.split("=");
                String key = splitObject[0].trim();
                String value = "";
                for (int i = 1; i < splitObject.length; ++i) {
                    if (i > 1) {
                        value = value + "=";
                    }
                    value = value + splitObject[i];
                }
                value = value.trim();
                if (key.equals("isa")) {
                    this.isa = value;
                } else if (key.equals("name")) {
                    this.name = value;
                } else if (key.equals("sourceTree")) {
                    this.sourceTree = value;
                } else if (key.equals("fileEncoding")) {
                    this.fileEncoding = Integer.valueOf(value);
                } else if (key.equals("explicitFileType")) {
                    this.explicitFileType = value;
                } else if (key.equals("lastKnownFileType")) {
                    this.lastKnownFileType = value;
                } else if (key.equals("path")) {
                    this.path = value;
                } else if (key.equals("children")) {
                    this.children = parser.getIdentifierList(value);
                } else if (key.equals("includeInIndex")) {
                    this.includeInIndex = Integer.valueOf(value);
                }
                parserObject = parser.parseNextObject();
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectFormatException(ex);
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int numberOfTabs) {
        String tabString = "";
        for (int i = 0; i < numberOfTabs; ++i) {
            tabString = tabString + "\t";
        }
        String returnString = "";
        if (this.isa.equals("PBXFileReference")) {
            returnString = returnString + tabString + this.reference.toString() + " = {isa = " + this.isa + "; ";
            if (this.explicitFileType != null) {
                returnString = returnString + "explicitFileType = " + this.explicitFileType + "; ";
            }
            if (this.includeInIndex != null) {
                returnString = returnString + "includeInIndex = " + this.includeInIndex + "; ";
            }
            if (this.lastKnownFileType != null) {
                returnString = returnString + "lastKnownFileType = " + this.lastKnownFileType + "; ";
            }
            if (this.name != null) {
                returnString = returnString + "name = " + this.name + "; ";
            }
            if (this.path != null) {
                returnString = returnString + "path = " + this.path + "; ";
            }
            if (this.sourceTree != null) {
                returnString = returnString + "sourceTree = " + this.sourceTree + "; ";
            }
            if (this.fileEncoding != null) {
                returnString = returnString + "fileEncoding = " + this.fileEncoding + "; ";
            }
            returnString = returnString + "};";
        } else {
            returnString = returnString + tabString + this.reference.toString() + " = {\n";
            returnString = returnString + tabString + "\tisa = " + this.isa + ";\n";
            returnString = returnString + tabString + "\tchildren = (\n";
            if (this.children != null) {
                for (CommentedIdentifier child : this.children) {
                    returnString = returnString + tabString + "\t\t" + child.toString() + ",\n";
                }
            }
            returnString = returnString + tabString + "\t);\n";
            if (this.name != null) {
                returnString = returnString + tabString + "\tname = " + this.name + ";\n";
            }
            if (this.path != null) {
                returnString = returnString + tabString + "\tpath = " + this.path + ";\n";
            }
            if (this.sourceTree != null) {
                returnString = returnString + tabString + "\tsourceTree = " + this.sourceTree + ";\n";
            }
            returnString = returnString + tabString + "};";
        }
        return returnString;
    }

    public boolean equals(Object o) {
        PBXFileElement oFileElement;
        if (o instanceof PBXFileElement && (oFileElement = (PBXFileElement)o).getPath() != null && this.path != null) {
            return oFileElement.getPath().equals(this.path);
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.reference);
        builder.append((Object)this.isa);
        builder.append((Object)this.name);
        builder.append((Object)this.sourceTree);
        builder.append((Object)this.fileEncoding);
        builder.append((Object)this.includeInIndex);
        builder.append((Object)this.explicitFileType);
        builder.append((Object)this.lastKnownFileType);
        builder.append((Object)this.path);
        builder.append(this.children);
        return builder.toHashCode();
    }

    public void addChild(String reference, String comment) {
        CommentedIdentifier child = new CommentedIdentifier(reference, comment);
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    public void addChild(CommentedIdentifier child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    @Override
    public int compareTo(PBXFileElement o) {
        return this.reference.getIdentifier().compareTo(o.getReference().getIdentifier());
    }

    public CommentedIdentifier getReference() {
        return this.reference;
    }

    public String getIsa() {
        return this.isa;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceTree() {
        return this.sourceTree;
    }

    public Integer getFileEncoding() {
        return this.fileEncoding;
    }

    public Integer getIncludeInIndex() {
        return this.includeInIndex;
    }

    public String getExplicitFileType() {
        return this.explicitFileType;
    }

    public String getLastKnownFileType() {
        return this.lastKnownFileType;
    }

    public String getPath() {
        return this.path;
    }

    public List<CommentedIdentifier> getChildren() {
        return this.children;
    }

    public void setReference(CommentedIdentifier reference) {
        this.reference = reference;
    }

    public void setIsa(String isa) {
        this.isa = isa;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSourceTree(String sourceTree) {
        this.sourceTree = sourceTree;
    }

    public void setFileEncoding(Integer fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public void setIncludeInIndex(Integer includeInIndex) {
        this.includeInIndex = includeInIndex;
    }

    public void setExplicitFileType(String explicitFileType) {
        this.explicitFileType = explicitFileType;
    }

    public void setLastKnownFileType(String lastKnownFileType) {
        this.lastKnownFileType = lastKnownFileType;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setChildren(List<CommentedIdentifier> children) {
        this.children = children;
    }

    public PBXFileElement() {
    }

    @ConstructorProperties(value={"reference", "isa", "name", "sourceTree", "fileEncoding", "includeInIndex", "explicitFileType", "lastKnownFileType", "path", "children"})
    public PBXFileElement(CommentedIdentifier reference, String isa, String name, String sourceTree, Integer fileEncoding, Integer includeInIndex, String explicitFileType, String lastKnownFileType, String path, List<CommentedIdentifier> children) {
        this.reference = reference;
        this.isa = isa;
        this.name = name;
        this.sourceTree = sourceTree;
        this.fileEncoding = fileEncoding;
        this.includeInIndex = includeInIndex;
        this.explicitFileType = explicitFileType;
        this.lastKnownFileType = lastKnownFileType;
        this.path = path;
        this.children = children;
    }
}

