/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.ExperimentalApi;
import graphql.collect.ImmutableKit;
import graphql.language.AbstractDescribedNode;
import graphql.language.AstPrinter;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.ImplementingTypeDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.ListType;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.language.Value;
import graphql.parser.CommentParser;
import graphql.parser.NodeToRuleCapturingParser;
import graphql.parser.ParserEnvironment;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;

@ExperimentalApi
public class PrettyAstPrinter
extends AstPrinter {
    private final CommentParser commentParser;
    private final PrettyPrinterOptions options;

    public PrettyAstPrinter(NodeToRuleCapturingParser.ParserContext parserContext) {
        this(parserContext, PrettyPrinterOptions.defaultOptions);
    }

    public PrettyAstPrinter(NodeToRuleCapturingParser.ParserContext parserContext, PrettyPrinterOptions options) {
        super(false);
        this.commentParser = new CommentParser(parserContext);
        this.options = options;
        this.replacePrinter(DirectiveDefinition.class, this.directiveDefinition());
        this.replacePrinter(Document.class, this.document());
        this.replacePrinter(EnumTypeDefinition.class, this.enumTypeDefinition("enum"));
        this.replacePrinter(EnumTypeExtensionDefinition.class, this.enumTypeDefinition("extend enum"));
        this.replacePrinter(EnumValueDefinition.class, this.enumValueDefinition());
        this.replacePrinter(FieldDefinition.class, this.fieldDefinition());
        this.replacePrinter(InputObjectTypeDefinition.class, this.inputObjectTypeDefinition("input"));
        this.replacePrinter(InputObjectTypeExtensionDefinition.class, this.inputObjectTypeDefinition("extend input"));
        this.replacePrinter(InputValueDefinition.class, this.inputValueDefinition());
        this.replacePrinter(InterfaceTypeDefinition.class, this.implementingTypeDefinition("interface"));
        this.replacePrinter(InterfaceTypeExtensionDefinition.class, this.implementingTypeDefinition("extend interface"));
        this.replacePrinter(ObjectTypeDefinition.class, this.implementingTypeDefinition("type"));
        this.replacePrinter(ObjectTypeExtensionDefinition.class, this.implementingTypeDefinition("extend type"));
        this.replacePrinter(ScalarTypeDefinition.class, this.scalarTypeDefinition("scalar"));
        this.replacePrinter(ScalarTypeExtensionDefinition.class, this.scalarTypeDefinition("extend scalar"));
        this.replacePrinter(UnionTypeDefinition.class, this.unionTypeDefinition("union"));
        this.replacePrinter(UnionTypeExtensionDefinition.class, this.unionTypeDefinition("extend union"));
    }

    public String print(Node node) {
        StringBuilder builder = new StringBuilder();
        AstPrinter.NodePrinter<Node> nodePrinter = this._findPrinter(node);
        nodePrinter.print(builder, node);
        return builder.toString();
    }

    public static String print(String schemaDefinition, PrettyPrinterOptions options) {
        NodeToRuleCapturingParser parser = new NodeToRuleCapturingParser();
        ParserEnvironment parserEnvironment = ParserEnvironment.newParserEnvironment().document(schemaDefinition).build();
        Document document = parser.parseDocument(parserEnvironment);
        return new PrettyAstPrinter(parser.getParserContext(), options).print(document);
    }

    private AstPrinter.NodePrinter<Document> document() {
        return (out, node) -> {
            String firstLineComment = this.commentParser.getCommentOnFirstLineOfDocument((Document)node).map(this::comment).map(this.append("\n")).orElse("");
            out.append(firstLineComment);
            out.append(this.join(node.getDefinitions(), "\n\n")).append("\n");
            String endComments = this.comments(this.commentParser.getCommentsAfterAllDefinitions((Document)node), "\n");
            out.append(endComments);
        };
    }

    private AstPrinter.NodePrinter<DirectiveDefinition> directiveDefinition() {
        return (out, node) -> {
            out.append(this.outset(node));
            String locations = this.join(node.getDirectiveLocations(), " | ");
            String repeatable = node.isRepeatable() ? "repeatable " : "";
            out.append("directive @").append(node.getName()).append(this.block(node.getInputValueDefinitions(), node, "(", ")", "\n", ", ", "")).append(" ").append(repeatable).append("on ").append(locations);
        };
    }

    private AstPrinter.NodePrinter<EnumTypeDefinition> enumTypeDefinition(String nodeName) {
        return (out, node) -> {
            out.append(this.outset(node));
            out.append(this.spaced(nodeName, node.getName(), this.directives(node.getDirectives()), this.block(node.getEnumValueDefinitions(), node, "{", "}", "\n", null, null)));
        };
    }

    private AstPrinter.NodePrinter<EnumValueDefinition> enumValueDefinition() {
        return (out, node) -> {
            out.append(this.outset(node));
            out.append(this.spaced(node.getName(), this.directives(node.getDirectives())));
        };
    }

    private AstPrinter.NodePrinter<FieldDefinition> fieldDefinition() {
        return (out, node) -> {
            out.append(this.outset(node));
            out.append(node.getName()).append(this.block(node.getInputValueDefinitions(), node, "(", ")", "\n", ", ", "")).append(": ").append(this.spaced(this.type(node.getType()), this.directives(node.getDirectives())));
        };
    }

    private String type(Type type) {
        if (type instanceof NonNullType) {
            NonNullType inner = (NonNullType)type;
            return this.wrap("", this.type(inner.getType()), "!");
        }
        if (type instanceof ListType) {
            ListType inner = (ListType)type;
            return this.wrap("[", this.type(inner.getType()), "]");
        }
        TypeName inner = (TypeName)type;
        return inner.getName();
    }

    private AstPrinter.NodePrinter<InputObjectTypeDefinition> inputObjectTypeDefinition(String nodeName) {
        return (out, node) -> {
            out.append(this.outset(node));
            out.append(this.spaced(nodeName, node.getName(), this.directives(node.getDirectives()), this.block(node.getInputValueDefinitions(), node, "{", "}", "\n", null, null)));
        };
    }

    private AstPrinter.NodePrinter<InputValueDefinition> inputValueDefinition() {
        String nameTypeSep = ": ";
        String defaultValueEquals = "= ";
        return (out, node) -> {
            Value defaultValue = node.getDefaultValue();
            out.append(this.outset(node));
            out.append(this.spaced(node.getName() + nameTypeSep + this.type(node.getType()), this.wrap(defaultValueEquals, defaultValue, ""), this.directives(node.getDirectives())));
        };
    }

    private <T extends ImplementingTypeDefinition<?>> AstPrinter.NodePrinter<T> implementingTypeDefinition(String nodeName) {
        return (out, node) -> {
            out.append(this.outset(node));
            out.append(this.spaced(nodeName, node.getName(), this.wrap("implements ", this.block(node.getImplements(), node, "", "", " &\n", " & ", ""), ""), this.directives(node.getDirectives()), this.block(node.getFieldDefinitions(), node, "{", "}", "\n", null, null)));
        };
    }

    private AstPrinter.NodePrinter<ScalarTypeDefinition> scalarTypeDefinition(String nodeName) {
        return (out, node) -> {
            out.append(this.outset(node));
            out.append(this.spaced(nodeName, node.getName(), this.directives(node.getDirectives())));
        };
    }

    private AstPrinter.NodePrinter<UnionTypeDefinition> unionTypeDefinition(String nodeName) {
        String barSep = " | ";
        String equals = "= ";
        return (out, node) -> {
            out.append(this.outset(node));
            out.append(this.spaced(nodeName, node.getName(), this.directives(node.getDirectives()), equals + this.join(node.getMemberTypes(), barSep)));
        };
    }

    private String node(Node node, Class startClass) {
        if (startClass != null) {
            Assert.assertTrue(startClass.isInstance(node), () -> "The starting class must be in the inherit tree");
        }
        StringBuilder builder = new StringBuilder();
        String comments = this.comments(this.commentParser.getLeadingComments(node), "\n");
        builder.append(comments);
        AstPrinter.NodePrinter<Node> printer = this._findPrinter(node, startClass);
        printer.print(builder, node);
        this.commentParser.getTrailingComment(node).map(this::comment).map(this.prepend(" ")).ifPresent(builder::append);
        return builder.toString();
    }

    private <T> boolean isEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    private boolean isEmpty(String s) {
        return s == null || s.isBlank();
    }

    private <T> List<T> nvl(List<T> list) {
        return list != null ? list : ImmutableKit.emptyList();
    }

    private String outset(Node<?> node) {
        String description = this.description(node);
        String commentsAfter = this.comments(this.commentParser.getCommentsAfterDescription(node), "\n");
        return description + commentsAfter;
    }

    private String description(Node<?> node) {
        boolean startNewLine;
        Description description = ((AbstractDescribedNode)node).getDescription();
        if (description == null || description.getContent() == null) {
            return "";
        }
        boolean bl = startNewLine = description.getContent().length() > 0 && description.getContent().charAt(0) == '\n';
        String s = description.isMultiLine() ? "\"\"\"" + (startNewLine ? "" : "\n") + description.getContent() + "\n\"\"\"\n" : "\"" + description.getContent() + "\"\n";
        return s;
    }

    private String comment(Comment comment) {
        return this.comments(Collections.singletonList(comment));
    }

    private String comments(List<Comment> comments) {
        return this.comments(comments, "");
    }

    private String comments(List<Comment> comments, String suffix) {
        return this.comments(comments, "", suffix);
    }

    private String comments(List<Comment> comments, String prefix, String suffix) {
        if (comments.isEmpty()) {
            return "";
        }
        return comments.stream().map(Comment::getContent).map(content -> "#" + content).collect(Collectors.joining("\n", prefix, suffix));
    }

    private String directives(List<Directive> directives) {
        return this.join(this.nvl(directives), " ");
    }

    private <T extends Node> String join(List<T> nodes, String delim) {
        return this.join(nodes, delim, "", "");
    }

    private <T extends Node> String join(List<T> nodes, String delim, String prefix, String suffix) {
        StringJoiner joiner = new StringJoiner(delim, prefix, suffix);
        for (Node node : nodes) {
            joiner.add(this.node(node));
        }
        return joiner.toString();
    }

    private String node(Node node) {
        return this.node(node, null);
    }

    private String spaced(String ... args) {
        return this.join(" ", args);
    }

    private Function<String, String> prepend(String prefix) {
        return text -> prefix + text;
    }

    private Function<String, String> append(String suffix) {
        return text -> text + suffix;
    }

    private String join(String delim, String ... args) {
        StringJoiner joiner = new StringJoiner(delim);
        for (String arg : args) {
            if (this.isEmpty(arg)) continue;
            joiner.add(arg);
        }
        return joiner.toString();
    }

    private <T extends Node> String block(List<T> nodes, Node parentNode, String prefix, String suffix, String separatorMultiline, String separatorSingleLine, String whenEmpty) {
        if (this.isEmpty(nodes)) {
            return whenEmpty != null ? whenEmpty : prefix + suffix;
        }
        boolean hasDescriptions = nodes.stream().filter(node -> node instanceof AbstractDescribedNode).map(node -> (AbstractDescribedNode)node).map(AbstractDescribedNode::getDescription).anyMatch(Objects::nonNull);
        boolean hasTrailingComments = nodes.stream().map(this.commentParser::getTrailingComment).anyMatch(Optional::isPresent);
        boolean hasLeadingComments = nodes.stream().mapToLong(node -> this.commentParser.getLeadingComments((Node<?>)node).size()).sum() > 0L;
        boolean isMultiline = hasDescriptions || hasTrailingComments || hasLeadingComments || separatorSingleLine == null;
        String appliedSeparator = isMultiline ? separatorMultiline : separatorSingleLine;
        String blockStart = this.commentParser.getBeginningOfBlockComment(parentNode, prefix).map(this::comment).map(commentText -> prefix + " " + commentText + "\n").orElseGet(() -> prefix + (isMultiline ? "\n" : ""));
        String blockEndComments = this.comments(this.commentParser.getEndOfBlockComments(parentNode, suffix), "\n", "");
        String blockEnd = (isMultiline ? "\n" : "") + suffix;
        String content = nodes.stream().map(this::node).collect(Collectors.joining(appliedSeparator));
        String possiblyIndentedContent = isMultiline ? this.indent(content + blockEndComments) : content + blockEndComments;
        return blockStart + possiblyIndentedContent + blockEnd;
    }

    private String indent(String text) {
        return this.indent(new StringBuilder(text)).toString();
    }

    private StringBuilder indent(StringBuilder stringBuilder) {
        String indentText = this.options.indentText;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (i == 0) {
                stringBuilder.replace(i, i, indentText);
                i += 2;
            }
            if (c != '\n') continue;
            stringBuilder.replace(i, i + 1, "\n" + indentText);
            i += 3;
        }
        return stringBuilder;
    }

    public static class PrettyPrinterOptions {
        private final String indentText;
        private static final PrettyPrinterOptions defaultOptions = new PrettyPrinterOptions(IndentType.SPACE, 2);

        private PrettyPrinterOptions(IndentType indentType, int indentWidth) {
            this.indentText = String.join((CharSequence)"", Collections.nCopies(indentWidth, indentType.character));
        }

        public static PrettyPrinterOptions defaultOptions() {
            return defaultOptions;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private IndentType indentType;
            private int indentWidth = 1;

            public Builder indentType(IndentType indentType) {
                this.indentType = indentType;
                return this;
            }

            public Builder indentWith(int indentWidth) {
                this.indentWidth = indentWidth;
                return this;
            }

            public PrettyPrinterOptions build() {
                return new PrettyPrinterOptions(this.indentType, this.indentWidth);
            }
        }

        public static enum IndentType {
            TAB("\t"),
            SPACE(" ");

            private final String character;

            private IndentType(String character) {
                this.character = character;
            }
        }
    }
}

