/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.authentication.basic;

import com.kms.katalon.core.webui.authentication.basic.BasicAuthenticationStrategy;
import com.kms.katalon.core.webui.authentication.basic.BiDiBasicAuth;
import com.kms.katalon.core.webui.authentication.basic.CdpBasicAuth;
import com.kms.katalon.core.webui.authentication.basic.EmbeddedCredentialsUrlBasicAuth;
import com.kms.katalon.core.webui.authentication.basic.NoOpBasicAuth;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.driver.bidi.BiDiDriverUtil;
import com.kms.katalon.core.webui.util.WebDriverUtil;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.HasAuthentication;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthenticationStrategyFactory {
    private static final Logger logger = LoggerFactory.getLogger(BasicAuthenticationStrategyFactory.class);
    private final String CHROME_BROWSER_NAME = "chrome";
    private final String FIREFOX_BROWSER_NAME = "firefox";
    private final String EDGE_BROWSER_NAME = "edge";

    public BasicAuthenticationStrategy getBasicAuthenticationStrategy() {
        WebDriver driver = DriverFactory.getWebDriver();
        String browserName = WebDriverUtil.getBrowserName(driver);
        if (!StringUtils.isEmpty((CharSequence)browserName)) {
            if (StringUtils.containsIgnoreCase((CharSequence)browserName, (CharSequence)"firefox")) {
                if (this.useBiDi()) {
                    logger.info("Using BiDi to handle Basic Authentication.");
                    return new BiDiBasicAuth();
                }
                logger.info("BiDi is not enabled. Falling back to EmbeddedCredentialsUrlBasicAuth for Basic Authentication.");
                return new EmbeddedCredentialsUrlBasicAuth();
            }
            if (StringUtils.containsIgnoreCase((CharSequence)browserName, (CharSequence)"chrome") || StringUtils.containsIgnoreCase((CharSequence)browserName, (CharSequence)"edge")) {
                if (this.isCdpSupportedForAuthenticationDriver(driver)) {
                    logger.info("Using CDP to handle Basic Authentication.");
                    return new CdpBasicAuth();
                }
                logger.info("CDP is not supported by the current driver. Falling back to EmbeddedCredentialsUrlBasicAuth for Basic Authentication.");
                return new EmbeddedCredentialsUrlBasicAuth();
            }
        }
        return new NoOpBasicAuth();
    }

    private boolean useBiDi() {
        WebDriver webDriver = DriverFactory.getWebDriver();
        if (webDriver instanceof RemoteWebDriver) {
            RemoteWebDriver remoteDriver = (RemoteWebDriver)webDriver;
            return BiDiDriverUtil.getBiDiCapability(remoteDriver.getCapabilities());
        }
        return false;
    }

    private boolean isCdpSupportedForAuthenticationDriver(WebDriver driver) {
        return driver instanceof HasAuthentication;
    }
}

