/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common;

import com.kms.katalon.core.webui.common.EBrowser;
import com.kms.katalon.core.webui.common.EngineLogger;
import com.kms.katalon.core.webui.common.Result;
import com.kms.katalon.core.webui.common.RunnerService;
import com.kms.katalon.core.webui.constants.StringConstants;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;

public class EWindow {
    private WebDriver driver;

    public EWindow(WebDriver parent) {
        this.driver = parent;
    }

    public Result getWindowTitle() {
        Result result = new Result();
        try {
            result.setReturnValue(this.driver.getTitle());
        }
        catch (Exception e) {
            result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT198"), e.getMessage()));
            result.setNeedReNewDriver(true);
        }
        return result;
    }

    public Result existWindow(String windowTitle) {
        String returnWindowHandle = this.driver.getWindowHandle();
        Set handles = this.driver.getWindowHandles();
        for (String handle : handles) {
            this.driver.switchTo().window(handle);
            if (!this.driver.getTitle().matches(windowTitle)) continue;
            return Result.reportHappyCase(true);
        }
        this.driver.switchTo().window(returnWindowHandle);
        return Result.reportUnHappyCase(false, false, "INT201", windowTitle);
    }

    public boolean switchToWindowUsingTitle(WebDriver driver, String title) {
        Set availableWindows = driver.getWindowHandles();
        for (String windowId : availableWindows) {
            if (!(driver = driver.switchTo().window(windowId)).getTitle().equals(title)) continue;
            return true;
        }
        return false;
    }

    public boolean closeWindowUsingTitle(WebDriver driver, String title) {
        Set availableWindows = driver.getWindowHandles();
        for (String windowId : availableWindows) {
            if (!(driver = driver.switchTo().window(windowId)).getTitle().equals(title)) continue;
            driver.close();
            return true;
        }
        return false;
    }

    public boolean switchToWindowUsingUrl(WebDriver driver, String url) {
        Set availableWindows = driver.getWindowHandles();
        for (String windowId : availableWindows) {
            if (!driver.switchTo().window(windowId).getCurrentUrl().equals(url)) continue;
            return true;
        }
        return false;
    }

    public boolean closeWindowUsingUrl(WebDriver driver, String url) {
        Set availableWindows = driver.getWindowHandles();
        for (String windowId : availableWindows) {
            if (!driver.switchTo().window(windowId).getCurrentUrl().equals(url)) continue;
            driver.close();
            return true;
        }
        return false;
    }

    public boolean switchToWindowUsingIndex(WebDriver driver, int index) {
        ArrayList availableWindows = new ArrayList(driver.getWindowHandles());
        if (index >= 0 && index < availableWindows.size()) {
            driver.switchTo().window((String)availableWindows.get(index));
            return true;
        }
        return false;
    }

    public boolean closeWindowUsingIndex(WebDriver driver, int index) {
        ArrayList availableWindows = new ArrayList(driver.getWindowHandles());
        if (index >= 0 && index < availableWindows.size()) {
            driver.switchTo().window((String)availableWindows.get(index));
            driver.close();
            return true;
        }
        return false;
    }

    private void stopLoading() {
        try {
            JavascriptExecutor executor = (JavascriptExecutor)this.driver;
            executor.executeScript("return window.stop()", new Object[0]);
        }
        catch (Exception exception) {}
    }

    public Result closeWindow(String windowTitle) {
        this.stopLoading();
        try {
            String currentWindowHandle = this.driver.getWindowHandle();
            Set windowIterator = this.driver.getWindowHandles();
            windowIterator.remove(currentWindowHandle);
            if (this.driver.getTitle().equalsIgnoreCase(windowTitle)) {
                this.driver.switchTo().window(currentWindowHandle).close();
                if (windowIterator.size() > 0) {
                    this.driver.switchTo().window((String)windowIterator.iterator().next());
                }
                return Result.reportHappyCase(null);
            }
            for (String windowHandle : windowIterator) {
                this.driver.switchTo().window(windowHandle);
                if (!this.driver.getTitle().equalsIgnoreCase(windowTitle)) continue;
                this.driver.switchTo().window(windowHandle).close();
                this.driver.switchTo().window(currentWindowHandle);
                return Result.reportHappyCase(null);
            }
            return Result.reportUnHappyCase(null, false, "INT205", windowTitle);
        }
        catch (Exception e) {
            return Result.reportUnHappyCaseWithMessage(false, true, EngineLogger.getLogMessageFromProperties("INT206") + windowTitle + EngineLogger.getLogMessageFromProperties("INT207") + e.getMessage());
        }
    }

    public Result switchToWindow(String windowTitle) {
        Result result;
        block10: {
            result = new Result();
            int timeOut = 60000;
            String originalInput = windowTitle;
            windowTitle = RunnerService.removeSpecialCharacters(windowTitle);
            try {
                if (this.driver.getWindowHandles().size() > 0) {
                    if (this.driver.getWindowHandles().size() > 1) {
                        Thread.sleep(5000L);
                    }
                    String parentWindowHandle = null;
                    try {
                        parentWindowHandle = this.driver.getWindowHandle();
                    }
                    catch (Exception exception) {}
                    Set windowIterator = this.driver.getWindowHandles();
                    windowIterator.remove(parentWindowHandle);
                    for (String windowHandle : windowIterator) {
                        this.driver.switchTo().window(windowHandle);
                        Result waitForPageLoad = this.waitForPageLoaded(timeOut);
                        if (!waitForPageLoad.getReturnValue().equals(true) || !RunnerService.removeSpecialCharacters(this.driver.getTitle()).equalsIgnoreCase(windowTitle)) continue;
                        return result;
                    }
                    if (parentWindowHandle != null) {
                        this.driver.switchTo().window(parentWindowHandle);
                        Result waitForPageLoad = this.waitForPageLoaded(timeOut);
                        if (waitForPageLoad.getReturnValue().equals(true) && RunnerService.removeSpecialCharacters(this.driver.getTitle()).equalsIgnoreCase(windowTitle)) {
                            return result;
                        }
                    }
                    result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT209"), originalInput));
                    break block10;
                }
                result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT210"), new Object[0]));
            }
            catch (TimeoutException te) {
                result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT208"), originalInput, te.getMessage()));
            }
            catch (Exception e) {
                result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT208"), originalInput, e.getMessage()));
                result.setNeedReNewDriver(true);
            }
        }
        return result;
    }

    public Result getURL() {
        Result result = new Result();
        try {
            result.setReturnValue(this.driver.getCurrentUrl());
        }
        catch (Exception e) {
            result.setMessage(MessageFormat.format(StringConstants.COMM_EXC_FAILED_TO_GET_URL, e.getMessage()));
            result.setNeedReNewDriver(true);
        }
        return result;
    }

    protected boolean verifyStringContains(String verifyString, String[] containsValues) {
        if (containsValues != null) {
            String[] stringArray = containsValues;
            int n = containsValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!verifyString.toLowerCase().contains(value.toLowerCase())) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public Result isURLContainValue(String value) {
        Result result = new Result();
        try {
            String url = this.driver.getCurrentUrl();
            if (!url.toLowerCase().contains(value)) {
                result.setMessage(MessageFormat.format(StringConstants.COMM_EXC_URL_DOES_NOT_CONTAIN, url, value));
                result.setReturnValue(false);
                return result;
            }
            result.setReturnValue(true);
        }
        catch (Exception e) {
            result.setMessage(MessageFormat.format(StringConstants.COMM_MSG_EXC_ERROR, e.getMessage()));
            result.setReturnValue(false);
            result.setNeedReNewDriver(true);
        }
        return result;
    }

    protected Result waitForPageLoaded(int timeOut) {
        return new EBrowser(this.driver).waitForPageLoaded(timeOut);
    }

    protected void handleTimeoutLoading() {
        System.out.println("Time's up");
        try {
            this.driver.findElement(By.tagName((String)"body")).sendKeys(new CharSequence[]{Keys.ESCAPE});
        }
        catch (Exception exception) {}
        System.out.println("Stop loading");
    }

    public Result isWindowTitleEqual(String windowTitle) {
        Result result = new Result();
        String originalTitle = windowTitle;
        windowTitle = RunnerService.removeSpecialCharacters(windowTitle);
        try {
            String actualTitle = this.driver.getTitle();
            if (RunnerService.removeSpecialCharacters(actualTitle).equalsIgnoreCase(windowTitle)) {
                result.setReturnValue(true);
            } else {
                result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT199"), originalTitle, actualTitle));
                result.setReturnValue(false);
            }
        }
        catch (Exception e) {
            result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT200"), e.getMessage()));
            result.setNeedReNewDriver(true);
        }
        return result;
    }
}

