/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver;

import com.kms.katalon.core.webui.util.WebDriverUtil;
import com.kms.katalon.selenium.driver.IExistingRemoteWebDriver;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;

public class ExistingRemoteWebDriver
extends RemoteWebDriver
implements IExistingRemoteWebDriver {
    private static final int REMOTE_BROWSER_CONNECT_TIMEOUT = 60000;
    private String oldSessionId;

    public ExistingRemoteWebDriver(URL remoteAddress, String oldSessionId, String webSocketUrl) throws ConnectException, MalformedURLException {
        super(WebDriverUtil.createCommandExecutorWithRunningSession(remoteAddress, oldSessionId, webSocketUrl), (Capabilities)new MutableCapabilities());
        ExistingRemoteWebDriver.waitForRemoteBrowserReady(remoteAddress);
        this.setSessionId(oldSessionId);
        this.oldSessionId = oldSessionId;
        this.startSession((Capabilities)new MutableCapabilities());
    }

    public ExistingRemoteWebDriver(String oldSessionId, CommandExecutor executor, Capabilities desiredCapabilities) {
        super(executor, desiredCapabilities);
        this.oldSessionId = oldSessionId;
    }

    protected void startSession(Capabilities desiredCapabilities) {
        if (this.oldSessionId == null) {
            return;
        }
        super.startSession(desiredCapabilities);
    }

    public Response createResponseForNewSession(String oldSessionId) {
        this.oldSessionId = oldSessionId;
        return super.createResponseForNewSession(oldSessionId);
    }

    protected Response execute(String driverCommand, Map<String, ?> parameters) {
        if ("newSession".equals(driverCommand)) {
            return this.createResponseForNewSession(this.oldSessionId);
        }
        return super.execute(driverCommand, parameters);
    }

    private static void waitForRemoteBrowserReady(URL url) throws ConnectException {
        long waitUntil = System.currentTimeMillis() + 60000L;
        boolean connectable = false;
        while (!connectable) {
            try {
                url.openConnection().connect();
                connectable = true;
            }
            catch (IOException iOException) {}
            if (waitUntil < System.currentTimeMillis()) {
                throw new ConnectException(String.format("Unable to connect to browser on host %s and port %s after %s seconds.", url.getHost(), url.getPort(), 60000));
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

