/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver.chrome;

import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.core.webui.common.internal.SeleniumBrowserInfo;
import com.kms.katalon.core.webui.driver.chrome.ChromeDriverUtil;
import com.kms.katalon.core.webui.driver.chromium.ChromiumDriverBuilder;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import com.kms.katalon.selenium.driver.CChromeDriver;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeDriverBuilder
extends ChromiumDriverBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ChromeDriverBuilder.class);
    private boolean useChromeForTesting = false;

    public ChromeDriverBuilder useChromeForTesting(boolean value) {
        this.useChromeForTesting = value;
        return this;
    }

    @Override
    protected AbstractDriverOptions<?> createOptions(Capabilities capabilities) {
        return WebDriverPropertyUtil.generateDefaultChromeOptions().merge(capabilities);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected WebDriver createDriver(AbstractDriverOptions<?> options) {
        Map mapData;
        void chromeOptions;
        if (!(options instanceof ChromeOptions)) {
            return null;
        }
        ChromeOptions chromeOptions2 = (ChromeOptions)options;
        Object extraCapability = chromeOptions.getCapability("goog:chromeOptions");
        if (extraCapability != null && extraCapability instanceof Map && (mapData = (Map)extraCapability).get("binary") != null) {
            logger.info("Use user's configured Chrome binary option: %s".formatted(mapData.get("binary")));
            System.setProperty("webdriver.chrome.driver", ChromeDriverUtil.getChromeDriverPath());
        } else if (this.useChromeForTesting) {
            this.setupDriverForCFT((ChromeOptions)chromeOptions);
        } else {
            this.setupDriverForChome((ChromeOptions)chromeOptions);
        }
        System.setProperty("webdriver.chrome.driver", ChromeDriverUtil.getChromeDriverPath());
        return new CChromeDriver((ChromeOptions)chromeOptions, driverConfigProvider.getActionDelayInMilisecond());
    }

    private void setupDriverForChome(ChromeOptions chromeOptions) {
        if (OSUtil.isMac()) {
            String chromeBinary = "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome";
            File chromeBinaryFilePath = new File(chromeBinary);
            if (chromeBinaryFilePath.exists()) {
                chromeOptions.setBinary(chromeBinary);
            }
        } else if (!OSUtil.isWindows()) {
            File chromeBinaryFilePath;
            String chromeBinary = ConsoleCommandExecutor.safeWhere((String)"google-chrome");
            if (StringUtils.isEmpty((CharSequence)"browser.startup.homepage")) {
                chromeBinary = "/usr/bin/google-chrome";
            }
            if ((chromeBinaryFilePath = new File(chromeBinary)).exists()) {
                chromeOptions.setBinary(chromeBinary);
            }
        }
    }

    private void setupDriverForCFT(ChromeOptions chromeOptions) {
        logger.info("Use managed Chrome browser & driver");
        String browserVersion = chromeOptions.getBrowserVersion();
        SeleniumBrowserInfo browserInfo = ChromeDriverUtil.getSeleniumBrowserInfo(browserVersion);
        logger.info("Chrome driver path: %s".formatted(browserInfo.getDriverPath()));
        logger.info("Chrome browser path: %s".formatted(browserInfo.getBrowserPath()));
        System.setProperty("webdriver.chrome.driver", browserInfo.getDriverPath());
        chromeOptions.setBinary(browserInfo.getBrowserPath());
    }
}

