/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.util;

import com.assertthat.selenium_shutterbug.core.Capture;
import com.assertthat.selenium_shutterbug.core.Shutterbug;
import com.kms.katalon.core.driver.IDriverType;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.util.internal.TestOpsUtil;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import io.appium.java_client.ios.IOSDriver;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.devtools.v138.page.Page;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class FileUtil {
    private static final String SCREENSHOT_FOLDER = "resources/screen";
    private static final String AUTHENTICATION_FOLDER = "resources/authentication";
    private static final String EXTENSIONS_FOLDER_NAME = "resources/extensions";
    private static final KeywordLogger logger = KeywordLogger.getInstance(FileUtil.class);

    public static String takesScreenshot(String fileName, List<TestObject> hideElements, Color hideColor, boolean isTestOpsVisionCheckPoint) throws Exception {
        if (!isTestOpsVisionCheckPoint) {
            FileUtil.takeDefaultScreenshot(fileName);
            return fileName;
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new IllegalArgumentException(StringConstants.KW_SCREENSHOT_EXCEPTION_FILENAME_NULL_EMPTY);
        }
        String savedFileName = TestOpsUtil.replaceTestOpsVisionFileName((String)fileName.trim());
        WebDriver driver = DriverFactory.getWebDriver();
        BufferedImage image = FileUtil.takeViewportScreenshot(driver);
        FileUtil.hideElements(image, driver, hideElements, hideColor, FileUtil.getScrollX(driver), FileUtil.getScrollY(driver));
        FileUtil.saveImage(image, savedFileName);
        return TestOpsUtil.getRelativePathForLog((String)savedFileName);
    }

    public static String takeFullPageScreenshot(String fileName, List<TestObject> ignoredElements, List<TestObject> hideElements, Color hideColor, boolean isTestOpsVisionCheckPoint) throws Exception {
        if (isTestOpsVisionCheckPoint && StringUtils.isBlank((CharSequence)fileName)) {
            throw new IllegalArgumentException(StringConstants.KW_SCREENSHOT_EXCEPTION_FILENAME_NULL_EMPTY);
        }
        String savedFileName = isTestOpsVisionCheckPoint ? TestOpsUtil.replaceTestOpsVisionFileName((String)fileName.trim()) : FileUtil.resolveFilePath(fileName);
        WebDriver driver = DriverFactory.getUnwrappedWebDriver();
        Map<WebElement, String> states = FileUtil.ignoreElements(driver, ignoredElements);
        BufferedImage image = null;
        IDriverType browser = DriverFactory.getExecutedBrowser();
        long baseX = 0L;
        if (browser != null && (WebUIDriverType.CHROME_DRIVER.getName().equals(browser.getName()) || WebUIDriverType.HEADLESS_DRIVER.getName().equals(browser.getName()) || WebUIDriverType.EDGE_CHROMIUM_DRIVER.getName().equals(browser.getName()))) {
            if (driver instanceof ChromeDriver || driver instanceof EdgeDriver) {
                HashMap<String, Object> screenshotConfig = new HashMap<String, Object>();
                screenshotConfig.put("format", Page.CaptureScreenshotFormat.PNG);
                screenshotConfig.put("quality", Optional.empty());
                screenshotConfig.put("clip", Optional.empty());
                screenshotConfig.put("fromSurface", Optional.of(true));
                screenshotConfig.put("captureBeyondViewport", Optional.of(true));
                screenshotConfig.put("optimizeForSpeed", Optional.empty());
                Map screenshot = null;
                if (driver instanceof ChromeDriver) {
                    screenshot = ((ChromeDriver)driver).executeCdpCommand("Page.captureScreenshot", screenshotConfig);
                } else if (driver instanceof EdgeDriver) {
                    screenshot = ((EdgeDriver)driver).executeCdpCommand("Page.captureScreenshot", screenshotConfig);
                }
                String base64Screenshot = (String)screenshot.get("data");
                byte[] imageBytes = Base64.getDecoder().decode(base64Screenshot);
                image = ImageIO.read(new ByteArrayInputStream(imageBytes));
            } else if (driver instanceof RemoteWebDriver) {
                image = Shutterbug.shootPage((WebDriver)driver, (Capture)Capture.FULL).getImage();
                long scrollbarSize = FileUtil.getScrollBarSize(driver);
                baseX -= scrollbarSize;
            }
        } else if (driver instanceof FirefoxDriver) {
            byte[] imageBytes = (byte[])((FirefoxDriver)driver).getFullPageScreenshotAs(OutputType.BYTES);
            image = ImageIO.read(new ByteArrayInputStream(imageBytes));
        } else {
            image = Shutterbug.shootPage((WebDriver)driver, (Capture)Capture.FULL_SCROLL).getImage();
        }
        FileUtil.restoreElements(driver, states);
        FileUtil.hideElements(image, driver, hideElements, hideColor, baseX, 0L);
        FileUtil.saveImage(image, savedFileName);
        return TestOpsUtil.getRelativePathForLog((String)savedFileName);
    }

    public static String takeElementScreenshot(String fileName, TestObject element, List<TestObject> hideElements, Color hideColor, boolean isTestOpsVisionCheckPoint) throws Exception {
        if (isTestOpsVisionCheckPoint && StringUtils.isBlank((CharSequence)fileName)) {
            throw new IllegalArgumentException(StringConstants.KW_SCREENSHOT_EXCEPTION_FILENAME_NULL_EMPTY);
        }
        if (element == null) {
            throw new IllegalArgumentException(StringConstants.KW_SCREENSHOT_EXCEPTION_ELEMENT_NULL);
        }
        String savedFileName = isTestOpsVisionCheckPoint ? TestOpsUtil.replaceTestOpsVisionFileName((String)fileName.trim()) : FileUtil.resolveFilePath(fileName);
        WebDriver driver = DriverFactory.getWebDriver();
        WebElement capturedElement = WebUiCommonHelper.findWebElement(element, 0);
        byte[] byteArray = (byte[])capturedElement.getScreenshotAs(OutputType.BYTES);
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(byteArray));
        Rectangle baseRect = capturedElement.getRect();
        FileUtil.hideElements(image, driver, hideElements, hideColor, baseRect.x, baseRect.y);
        FileUtil.saveImage(image, savedFileName);
        return TestOpsUtil.getRelativePathForLog((String)savedFileName);
    }

    public static String takeAreaScreenshot(String fileName, Rectangle rect, List<TestObject> hideElements, Color hideColor, boolean isTestOpsVisionCheckPoint) throws IOException {
        if (isTestOpsVisionCheckPoint && StringUtils.isBlank((CharSequence)fileName)) {
            throw new IllegalArgumentException(StringConstants.KW_SCREENSHOT_EXCEPTION_FILENAME_NULL_EMPTY);
        }
        if (rect == null) {
            throw new IllegalArgumentException(StringConstants.KW_SCREENSHOT_EXCEPTION_AREA_NULL);
        }
        String savedFileName = isTestOpsVisionCheckPoint ? TestOpsUtil.replaceTestOpsVisionFileName((String)fileName.trim()) : FileUtil.resolveFilePath(fileName);
        WebDriver driver = DriverFactory.getWebDriver();
        BufferedImage image = FileUtil.takeViewportScreenshot(driver);
        double devicePixelRatio = WebUiCommonHelper.getDevicePixelRatio(driver);
        Rectangle actualRect = FileUtil.getActualRectangle(rect, 0L, 0L, devicePixelRatio);
        if (actualRect.x + actualRect.width > image.getWidth() || actualRect.y + actualRect.height > image.getHeight()) {
            throw new IllegalArgumentException(StringConstants.KW_SCREENSHOT_EXCEPTION_AREA_LARGER);
        }
        image = FileUtil.hideElements(image, driver, hideElements, hideColor, FileUtil.getScrollX(driver), FileUtil.getScrollY(driver));
        FileUtil.saveImage(image.getSubimage(actualRect.x, actualRect.y, actualRect.width, actualRect.height), savedFileName);
        return TestOpsUtil.getRelativePathForLog((String)savedFileName);
    }

    private static Map<WebElement, String> ignoreElements(WebDriver driver, List<TestObject> testObjects) throws Exception {
        if (testObjects == null || driver == null) {
            return null;
        }
        HashMap<WebElement, String> preState = new HashMap<WebElement, String>();
        JavascriptExecutor jsx = (JavascriptExecutor)driver;
        int counter = 0;
        for (TestObject to : testObjects) {
            try {
                WebElement element = WebUiCommonHelper.findWebElement(to, 0);
                String state = jsx.executeScript("return arguments[0].style.visibility", new Object[]{element}).toString();
                preState.put(element, state);
                jsx.executeScript("arguments[0].style.visibility = 'hidden'", new Object[]{element});
                ++counter;
            }
            catch (Exception exception) {
                logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_SCREENSHOT_FULLPAGE_FAIL_HIDE_OBJECT, to.getObjectId()));
            }
        }
        logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_SCREENSHOT_FULLPAGE_HIDDEN_COUNTER, counter));
        return preState;
    }

    private static BufferedImage hideElements(BufferedImage screenshot, WebDriver driver, List<TestObject> testObjects, Color hideColor, long baseX, long baseY) {
        if (testObjects == null || testObjects.isEmpty()) {
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_SCREENSHOT_FULLPAGE_HIDDEN_COUNTER, 0));
            return screenshot;
        }
        Objects.requireNonNull(screenshot);
        Objects.requireNonNull(driver);
        Objects.requireNonNull(testObjects);
        int counter = 0;
        if (hideColor == null) {
            hideColor = Color.GRAY;
        }
        Graphics2D g = screenshot.createGraphics();
        g.setColor(hideColor);
        double pixelRatio = WebUiCommonHelper.getDevicePixelRatio(driver);
        for (TestObject to : testObjects) {
            try {
                WebElement element = WebUiCommonHelper.findWebElement(to, 0);
                Rectangle rect = FileUtil.getActualRectangle(element.getRect(), baseX, baseY, pixelRatio);
                if (rect.x < 0 || rect.y < 0 || rect.x > screenshot.getWidth() || rect.y > screenshot.getHeight()) {
                    logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_SCREENSHOT_FULLPAGE_FAIL_HIDE_OBJECT_OUT_OF_IMAGE, to.getObjectId()));
                    continue;
                }
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
                ++counter;
            }
            catch (Exception exception) {
                logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_SCREENSHOT_FULLPAGE_FAIL_HIDE_OBJECT, to.getObjectId()));
            }
        }
        g.dispose();
        logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_SCREENSHOT_FULLPAGE_HIDDEN_COUNTER, counter));
        return screenshot;
    }

    private static Rectangle getActualRectangle(Rectangle baseRect, long baseX, long baseY, double pixelRatio) {
        Objects.requireNonNull(baseRect);
        int actualRectX = (int)((double)((long)baseRect.x - baseX) * pixelRatio);
        int actualRectY = (int)((double)((long)baseRect.y - baseY) * pixelRatio);
        int actualRectW = (int)((double)baseRect.width * pixelRatio);
        int actualRectH = (int)((double)baseRect.height * pixelRatio);
        return new Rectangle(actualRectX, actualRectY, actualRectH, actualRectW);
    }

    private static void restoreElements(WebDriver driver, Map<WebElement, String> states) throws Exception {
        if (states == null || driver == null) {
            return;
        }
        JavascriptExecutor jsx = (JavascriptExecutor)driver;
        for (WebElement e : states.keySet()) {
            jsx.executeScript("arguments[0].style.visibility = '" + states.get(e) + "'", new Object[]{e});
        }
    }

    public static File extractScreenFiles() throws Exception {
        String path = FileUtil.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        File jarFile = new File(path = URLDecoder.decode(path, "utf-8"));
        if (jarFile.isFile()) {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                if (!name.startsWith(SCREENSHOT_FOLDER) || !name.endsWith(".png")) continue;
                String mappingFileName = name.replace("resources/screen/", "");
                File tmpFile = new File(System.getProperty("java.io.tmpdir") + mappingFileName);
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
                FileOutputStream fos = new FileOutputStream(tmpFile);
                IOUtils.copy((InputStream)jar.getInputStream(jarEntry), (OutputStream)fos);
                fos.flush();
                fos.close();
            }
            jar.close();
            return new File(System.getProperty("java.io.tmpdir"));
        }
        File folder = new File(path + "../resources/screen");
        return folder;
    }

    public static File getAuthenticationDirectory() throws IOException {
        String path = FileUtil.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        File jarFile = new File(path = URLDecoder.decode(path, "utf-8"));
        if (jarFile.isFile()) {
            String kmsIePath = jarFile.getParentFile().getParentFile().getAbsolutePath() + "/configuration/resources/authentication";
            return new File(kmsIePath);
        }
        File folder = new File(path + "../resources/authentication");
        return folder;
    }

    public static File getExtensionsDirectory() throws IOException {
        String path = FileUtil.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        File jarFile = new File(path = URLDecoder.decode(path, "utf-8"));
        if (jarFile.isFile()) {
            String kmsIePath = jarFile.getParentFile().getParentFile().getAbsolutePath() + "/configuration/resources/extensions";
            return new File(kmsIePath);
        }
        File folder = new File(path + ".." + File.separator + EXTENSIONS_FOLDER_NAME);
        return folder;
    }

    public static String getRelativePath(String path, String baseDir) {
        String relativePath = new File(baseDir).toPath().relativize(new File(path).toPath()).toString();
        return FilenameUtils.separatorsToUnix((String)relativePath);
    }

    public static boolean isInBaseFolder(String absolutePath, String absoluteBaseDir) {
        File file = new File(absolutePath);
        File baseDir = new File(absoluteBaseDir);
        return file.getAbsolutePath().startsWith(baseDir.getAbsolutePath());
    }

    private static BufferedImage takeViewportScreenshot(WebDriver driver) throws IOException {
        byte[] byteArray = (byte[])((TakesScreenshot)driver).getScreenshotAs(OutputType.BYTES);
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(byteArray));
        IDriverType executedBrowser = DriverFactory.getExecutedBrowser();
        if (executedBrowser != null ? StringUtils.equals((CharSequence)executedBrowser.getName(), (CharSequence)WebUIDriverType.IOS_DRIVER.getName()) : driver instanceof IOSDriver) {
            return FileUtil.removeBrowserAndOSStatusBar(driver, image);
        }
        return image;
    }

    private static BufferedImage removeBrowserAndOSStatusBar(WebDriver driver, BufferedImage image) {
        double devicePixelRatio = WebUiCommonHelper.getDevicePixelRatio(driver);
        int viewportWidth = (int)((double)WebUiCommonHelper.getViewportWidth(driver) * devicePixelRatio);
        int viewportHeight = (int)((double)WebUiCommonHelper.getViewportHeight(driver) * devicePixelRatio);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (viewportHeight != image.getHeight() || viewportWidth != image.getWidth()) {
            return image.getSubimage(imageWidth - viewportWidth, imageHeight - viewportHeight, viewportWidth, viewportHeight);
        }
        return image;
    }

    public static void saveImage(BufferedImage image, String fileName) throws IOException, SecurityException {
        File file = new File(fileName);
        TestOpsUtil.ensureDirectory((File)file, (boolean)true);
        ImageIO.write((RenderedImage)image, "png", file);
    }

    private static void takeDefaultScreenshot(String fileName) throws WebDriverException, StepFailedException, IOException {
        fileName = FileUtil.resolveFilePath(fileName);
        FileUtils.copyFile((File)((File)((TakesScreenshot)DriverFactory.getWebDriver()).getScreenshotAs(OutputType.FILE)), (File)new File(fileName), (boolean)false);
    }

    private static String resolveFilePath(String fileName) {
        File file = new File(fileName);
        if (file.isAbsolute()) {
            return fileName;
        }
        return logger.getLogFolderPath() + File.separator + fileName;
    }

    private static long getScrollX(WebDriver driver) {
        if (driver == null) {
            return 0L;
        }
        try {
            Object result = ((JavascriptExecutor)driver).executeScript("return (window.pageXOffset !== undefined)\n  ? window.pageXOffset\n  : (document.documentElement || document.body.parentNode || document.body).scrollLeft;", new Object[0]);
            return FileUtil.convertExecuteScriptResultToLong(result);
        }
        catch (NullPointerException | WebDriverException throwable) {
            return 0L;
        }
    }

    private static long getScrollY(WebDriver driver) {
        if (driver == null) {
            return 0L;
        }
        try {
            Object result = ((JavascriptExecutor)driver).executeScript("return (window.pageYOffset !== undefined)\n  ? window.pageYOffset\n  : (document.documentElement || document.body.parentNode || document.body).scrollTop;", new Object[0]);
            return FileUtil.convertExecuteScriptResultToLong(result);
        }
        catch (NullPointerException | WebDriverException throwable) {
            return 0L;
        }
    }

    private static long getScrollBarSize(WebDriver driver) {
        if (driver == null) {
            return 0L;
        }
        try {
            Object result = ((JavascriptExecutor)driver).executeScript("return (window.innerWidth - document.body.clientWidth)", new Object[0]);
            return FileUtil.convertExecuteScriptResultToLong(result);
        }
        catch (NullPointerException | WebDriverException throwable) {
            return 0L;
        }
    }

    private static long convertExecuteScriptResultToLong(Object result) {
        if (result instanceof Double) {
            return ((Double)result).longValue();
        }
        if (result instanceof Long) {
            return (Long)result;
        }
        return ((Integer)result).longValue();
    }
}

