/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.dataprovider;

import com.kms.katalon.dal.IProjectDataProvider;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.manager.ProjectFileServiceManager;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class ProjectFileServiceDataProvider
implements IProjectDataProvider {
    public ProjectEntity addNewProject(String name, String description, short pageLoadTimeout, String projectValue) throws Exception {
        return ProjectFileServiceManager.addNewProject(name, description, pageLoadTimeout, projectValue);
    }

    public ProjectEntity addNewTestOpsProjectWithoutNewFolder(String name, String description, short pageLoadTimeout, String projectValue) throws Exception {
        return ProjectFileServiceManager.addNewTestOpsProjectWithoutNewFolder(name, description, pageLoadTimeout, projectValue);
    }

    public ProjectEntity openProjectWithoutClasspath(String projectValue) throws Exception {
        return ProjectFileServiceManager.openProjectWithoutClasspath(projectValue);
    }

    public ProjectEntity updateProject(String newName, String description, String projectPk, short pageLoadTimeout, boolean checkProp, ProjectType projectType) throws Exception {
        return ProjectFileServiceManager.updateProject(newName, description, projectPk, pageLoadTimeout, checkProp, projectType);
    }

    public Boolean isDuplicationProjectName(String name, String projectPK) throws Exception {
        return ProjectFileServiceManager.isDuplicationProjectName(name, projectPK);
    }

    public String getSystemTempFolder() {
        return FileServiceConstant.TEMP_DIR;
    }

    public String getSettingFolder() {
        return "settings";
    }

    public String getExternalSettingFolder() {
        return FileServiceConstant.EXTERNAL_SETTING_DIR;
    }

    public String getInternalSettingFolder() {
        return FileServiceConstant.INTERNAL_SETTING_DIR;
    }

    public void updateProject(ProjectEntity projectEntity) throws Exception {
        EntityService.getInstance().saveEntity((FileEntity)projectEntity);
    }

    public File getProjectFile(String folderLocation) {
        if (folderLocation == null) {
            return null;
        }
        File folder = new File(folderLocation);
        if (!folder.exists()) {
            return null;
        }
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (("." + FilenameUtils.getExtension((String)file.getAbsolutePath())).equals(ProjectEntity.getProjectFileExtension())) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public ProjectEntity getProject(String projectFileLocation) throws DALException {
        try {
            ProjectEntity project = (ProjectEntity)EntityService.getInstance().getEntityByPath(projectFileLocation);
            if (project != null) {
                File projectFile = new File(projectFileLocation);
                project.setProjectFile(projectFile);
            }
            return project;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public ProjectEntity newProjectEntity(String name, String description, String projectLocation, boolean legacy) throws DALException {
        return ProjectFileServiceManager.newProjectEntity(name, description, projectLocation, legacy);
    }

    public ProjectEntity updateProjectEntity(File projectFile, ProjectEntity newInfo) throws DALException {
        try {
            ProjectEntity project = (ProjectEntity)EntityService.getInstance().getEntityByPath(projectFile.getAbsolutePath());
            project.setProjectFile(projectFile);
            project.setName(newInfo.getName());
            project.setDescription(newInfo.getDescription());
            FileUtils.deleteQuietly((File)projectFile);
            EntityService.getInstance().saveEntity((FileEntity)project);
            return project;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }
}

