/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.dataprovider;

import com.kms.katalon.dal.TestSuiteCollectionDataProvider;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.exception.InvalidNameException;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.constants.StringConstants;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.dal.fileservice.util.PathValidationUtil;
import com.kms.katalon.dal.state.DataProviderState;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TestSuiteCollectionFileServiceDataProvider
implements TestSuiteCollectionDataProvider {
    private EntityService getEntityService() throws DALException {
        try {
            return EntityService.getInstance();
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public List<TestSuiteCollectionEntity> getAll(ProjectEntity project) throws DALException {
        try {
            List<TestSuiteCollectionEntity> allTestSuiteCollections = EntityFileServiceManager.getDescendants(FolderFileServiceManager.getTestSuiteRoot(project), TestSuiteCollectionEntity.class);
            return allTestSuiteCollections;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public TestSuiteCollectionEntity get(String testSuiteCollectionId) throws DALException {
        try {
            TestSuiteCollectionEntity testSuiteCollection = (TestSuiteCollectionEntity)EntityFileServiceManager.get(new File(testSuiteCollectionId));
            if (testSuiteCollection != null) {
                testSuiteCollection.setProject(DataProviderState.getInstance().getCurrentProject());
            }
            return testSuiteCollection;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public void delete(String testSuiteCollectionId) throws DALException {
        TestSuiteCollectionEntity testSuiteCollection = this.get(testSuiteCollectionId);
        if (testSuiteCollection == null) {
            return;
        }
        try {
            EntityService.getInstance().deleteEntity((FileEntity)testSuiteCollection);
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public TestSuiteCollectionEntity add(FolderEntity parentFolder, String newName) throws DALException, FilePathTooLongException {
        try {
            this.getEntityService().validateName(newName);
            this.checkDuplicate(parentFolder, newName);
            TestSuiteCollectionEntity testSuiteCollection = new TestSuiteCollectionEntity();
            testSuiteCollection.setExecutionMode(TestSuiteCollectionEntity.ExecutionMode.SEQUENTIAL);
            testSuiteCollection.setParentFolder(parentFolder);
            testSuiteCollection.setProject(parentFolder.getProject());
            testSuiteCollection.setName(newName);
            PathValidationUtil.validatePathLength((FileEntity)testSuiteCollection);
            this.getEntityService().saveEntity((FileEntity)testSuiteCollection);
            return testSuiteCollection;
        }
        catch (FilePathTooLongException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public TestSuiteCollectionEntity rename(String testSuiteCollectionId, String newName) throws DALException, FilePathTooLongException {
        TestSuiteCollectionEntity currentTestSuiteCollection;
        block4: {
            this.getEntityService().validateName(newName);
            currentTestSuiteCollection = this.get(testSuiteCollectionId);
            if (currentTestSuiteCollection != null) break block4;
            return null;
        }
        try {
            TestSuiteCollectionEntity clonedTestSuiteCollection = (TestSuiteCollectionEntity)currentTestSuiteCollection.clone();
            clonedTestSuiteCollection.setName(newName);
            PathValidationUtil.validatePathLength((FileEntity)clonedTestSuiteCollection);
            this.checkDuplicate(currentTestSuiteCollection.getParentFolder(), newName);
            this.getEntityService().deleteEntity((FileEntity)currentTestSuiteCollection);
            currentTestSuiteCollection.setName(newName);
            this.getEntityService().saveEntity((FileEntity)currentTestSuiteCollection);
            return currentTestSuiteCollection;
        }
        catch (FilePathTooLongException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public void update(TestSuiteCollectionEntity newTestSuiteCollection) throws DALException {
        try {
            this.getEntityService().saveEntity((FileEntity)newTestSuiteCollection);
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    private void checkDuplicate(FolderEntity parentFolder, String newName) throws DALException {
        if (!newName.equals(this.getEntityService().getAvailableName(parentFolder.getId(), newName, true))) {
            throw new InvalidNameException(StringConstants.DP_EXC_NAME_ALREADY_EXISTED);
        }
    }

    public TestSuiteCollectionEntity move(String testSuiteCollectionId, FolderEntity newLocation) throws DALException, FilePathTooLongException {
        TestSuiteCollectionEntity testSuiteCollection = this.get(testSuiteCollectionId);
        if (testSuiteCollection.getParentFolder().equals((Object)newLocation)) {
            return null;
        }
        try {
            return EntityFileServiceManager.move(testSuiteCollection, newLocation);
        }
        catch (FilePathTooLongException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public TestSuiteCollectionEntity copy(String testSuiteCollectionId, FolderEntity location) throws DALException, FilePathTooLongException {
        TestSuiteCollectionEntity testSuiteCollection = this.get(testSuiteCollectionId);
        try {
            return EntityFileServiceManager.copy(testSuiteCollection, location);
        }
        catch (FilePathTooLongException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public List<TestSuiteCollectionEntity> getTestSuiteCollectionReferences(TestSuiteEntity testSuite, ProjectEntity project) throws DALException {
        try {
            List<TestSuiteCollectionEntity> allTestSuiteCollections = EntityFileServiceManager.getDescendants(FolderFileServiceManager.getTestSuiteRoot(project), TestSuiteCollectionEntity.class);
            ArrayList<TestSuiteCollectionEntity> testSuiteReferences = new ArrayList<TestSuiteCollectionEntity>();
            for (TestSuiteCollectionEntity potential : allTestSuiteCollections) {
                if (!potential.hasTestSuiteReferences(testSuite)) continue;
                testSuiteReferences.add(potential);
            }
            return testSuiteReferences;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public void removeTestSuiteCollectionReferences(TestSuiteEntity testSuite, List<TestSuiteCollectionEntity> testSuiteReferences) throws DALException {
        try {
            for (TestSuiteCollectionEntity referralCollection : testSuiteReferences) {
                if (!referralCollection.hasTestSuiteReferences(testSuite)) continue;
                referralCollection.getTestSuiteRunConfigurations().removeAll(referralCollection.findRunConfigurations(testSuite));
                this.update(referralCollection);
            }
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public void updateTestSuiteCollectionReferences(TestSuiteEntity testSuite, ProjectEntity project) throws DALException {
        try {
            for (TestSuiteCollectionEntity referralCollection : this.getTestSuiteCollectionReferences(testSuite, project)) {
                this.getEntityService().saveEntity((FileEntity)referralCollection);
            }
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }
}

