/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.util;

import com.kms.katalon.dal.exception.InvalidNameException;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.entity.constants.StringConstants;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;

public class PathValidationUtil {
    private static IPreferenceStore prefStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");

    public static boolean isPathValidationEnabled() {
        if (!"win32".equals(Platform.getOS())) {
            return false;
        }
        return prefStore.contains("general.validateFilePathLength") ? prefStore.getBoolean("general.validateFilePathLength") : true;
    }

    public static void validateNameLength(String name) throws InvalidNameException {
        if (!PathValidationUtil.isPathValidationEnabled() || name == null) {
            return;
        }
        if (name.length() > 255) {
            throw new InvalidNameException(MessageFormat.format(StringConstants.EXC_NAME_IS_TOO_LONG, name.length()));
        }
    }

    private static void validatePathLength(String path) throws FilePathTooLongException {
        if (path != null && path.length() > 255) {
            throw new FilePathTooLongException(path.length(), 255);
        }
    }

    public static void validatePathLength(FileEntity fileEntity) throws Exception {
        PathValidationUtil.validatePathLength(fileEntity.getLocation(), fileEntity);
    }

    public static void validatePathLength(String path, FileEntity fileEntity) throws Exception {
        if (!PathValidationUtil.isPathValidationEnabled() || path == null && fileEntity == null) {
            return;
        }
        PathValidationUtil.validatePathLength(path);
        if (fileEntity != null) {
            if (fileEntity instanceof FolderEntity) {
                FolderEntity folderEntity = (FolderEntity)fileEntity;
                PathValidationUtil.validateFolderPathLength(path, folderEntity, fileEntity.getProject());
            } else if (fileEntity instanceof TestCaseEntity) {
                TestCaseEntity testCase = (TestCaseEntity)fileEntity;
                PathValidationUtil.validateTestCaseScriptPath(testCase);
            } else {
                PathValidationUtil.validatePathLength(fileEntity.getLocation());
            }
        }
    }

    private static void validateTestCaseScriptPath(TestCaseEntity testCase) throws FilePathTooLongException {
        PathValidationUtil.validatePathLength(testCase.getLocation());
        String scriptPath = testCase.getProject().getFolderLocation() + File.separator + GroovyUtil.getScriptPackageRelativePathForTestCase((TestCaseEntity)testCase) + File.separator + GroovyUtil.getGroovyClassName((TestCaseEntity)testCase) + ".groovy";
        PathValidationUtil.validatePathLength(scriptPath);
    }

    private static void validateFolderPathLength(String newPath, FolderEntity folder, ProjectEntity project) throws Exception {
        if (!PathValidationUtil.isPathValidationEnabled()) {
            return;
        }
        if (newPath.length() > 255) {
            throw new FilePathTooLongException(newPath.length(), 255);
        }
        if (folder.getLocation().contains(FileServiceConstant.getDataFileRootFolderLocation(project.getFolderLocation()))) {
            PathValidationUtil.validateDataFileFolderPathLength(newPath, folder, "");
        }
        if (folder.getLocation().contains(FileServiceConstant.getTestCaseRootFolderLocation(project.getFolderLocation()))) {
            PathValidationUtil.validateTestCaseFolderPathLength(newPath, folder, "", project);
        }
        if (folder.getLocation().contains(FileServiceConstant.getTestSuiteRootFolderLocation(project.getFolderLocation()))) {
            PathValidationUtil.validateTestSuiteFolderPathLength(newPath, folder, "");
        }
        if (folder.getLocation().contains(FileServiceConstant.getObjectRepositoryRootFolderLocation(project.getFolderLocation()))) {
            PathValidationUtil.validateObjectRepositoryFolderPathLength(newPath, folder, "");
        }
    }

    private static void validateDataFileFolderPathLength(String newPath, FolderEntity folder, String relativePath) throws Exception {
        String metaDataFilePath = PathValidationUtil.buildMetaFilePathFromPath(newPath);
        PathValidationUtil.validatePathLength(metaDataFilePath);
        List<DataFileEntity> dataFileEntities = PathValidationUtil.getChildren(folder, DataFileEntity.class);
        for (DataFileEntity dataFile : dataFileEntities) {
            String fileName = dataFile.getName() + DataFileEntity.getTestDataFileExtension();
            PathValidationUtil.validateChildPath(newPath, fileName, relativePath, dataFile.getName());
        }
        List<FolderEntity> folderEntities = PathValidationUtil.getChildren(folder, FolderEntity.class);
        for (FolderEntity childFolder : folderEntities) {
            String newFolderPath = PathValidationUtil.validateFolderEntityPathLength(newPath, relativePath, childFolder);
            PathValidationUtil.validateDataFileFolderPathLength(newFolderPath, childFolder, relativePath + (relativePath.isEmpty() ? "" : File.separator) + folder.getName());
        }
    }

    private static void validateTestCaseFolderPathLength(String newPath, FolderEntity folder, String relativePath, ProjectEntity project) throws Exception {
        String metaDataFilePath = PathValidationUtil.buildMetaFilePathFromPath(newPath);
        PathValidationUtil.validatePathLength(metaDataFilePath);
        List<TestCaseEntity> testCaseEntities = PathValidationUtil.getChildren(folder, TestCaseEntity.class);
        for (TestCaseEntity testCase : testCaseEntities) {
            String fileName = testCase.getName() + TestCaseEntity.getTestCaseFileExtension();
            PathValidationUtil.validateChildPath(newPath, fileName, relativePath, testCase.getName());
        }
        List<FolderEntity> folderEntities = PathValidationUtil.getChildren(folder, FolderEntity.class);
        for (FolderEntity childFolder : folderEntities) {
            String newFolderPath = PathValidationUtil.validateFolderEntityPathLength(newPath, relativePath, childFolder);
            String newRelativePath = PathValidationUtil.buildRelativePath(relativePath, childFolder.getName());
            PathValidationUtil.validateTestCaseFolderPathLength(newFolderPath, childFolder, newRelativePath, project);
        }
    }

    private static void validateTestSuiteFolderPathLength(String newPath, FolderEntity folder, String relativePath) throws Exception {
        String metaDataFilePath = PathValidationUtil.buildMetaFilePathFromPath(newPath);
        PathValidationUtil.validatePathLength(metaDataFilePath);
        List<TestSuiteEntity> testSuiteEntities = PathValidationUtil.getChildren(folder, TestSuiteEntity.class);
        for (TestSuiteEntity testSuite : testSuiteEntities) {
            String fileName = testSuite.getName() + TestSuiteEntity.getTestSuiteFileExtension();
            PathValidationUtil.validateChildPath(newPath, fileName, relativePath, testSuite.getName());
        }
        List<FolderEntity> folderEntities = PathValidationUtil.getChildren(folder, FolderEntity.class);
        for (FolderEntity childFolder : folderEntities) {
            String newFolderPath = PathValidationUtil.validateFolderEntityPathLength(newPath, relativePath, childFolder);
            String newRelativePath = PathValidationUtil.buildRelativePath(relativePath, childFolder.getName());
            PathValidationUtil.validateTestSuiteFolderPathLength(newFolderPath, childFolder, newRelativePath);
        }
    }

    private static void validateObjectRepositoryFolderPathLength(String newPath, FolderEntity folder, String relativePath) throws Exception {
        String metaDataFilePath = PathValidationUtil.buildMetaFilePathFromPath(newPath);
        PathValidationUtil.validatePathLength(metaDataFilePath);
        List<WebElementEntity> webElementEntities = PathValidationUtil.getChildren(folder, WebElementEntity.class);
        for (WebElementEntity webElement : webElementEntities) {
            String fileName = webElement.getName() + WebElementEntity.getWebElementFileExtension();
            PathValidationUtil.validateChildPath(newPath, fileName, relativePath, webElement.getName());
        }
        List<FolderEntity> folderEntities = PathValidationUtil.getChildren(folder, FolderEntity.class);
        for (FolderEntity childFolder : folderEntities) {
            String newFolderPath = PathValidationUtil.validateFolderEntityPathLength(newPath, relativePath, childFolder);
            String newRelativePath = PathValidationUtil.buildRelativePath(relativePath, childFolder.getName());
            PathValidationUtil.validateObjectRepositoryFolderPathLength(newFolderPath, childFolder, newRelativePath);
        }
    }

    private static String validateFolderEntityPathLength(String newPath, String relativePath, FolderEntity folder) throws FilePathTooLongException {
        String newFolderPath = newPath + File.separator + folder.getName();
        if (newFolderPath.length() > 255) {
            String displayPath = PathValidationUtil.buildRelativePath(relativePath, folder.getName());
            throw new FilePathTooLongException(newFolderPath.length(), displayPath, 255);
        }
        return newFolderPath;
    }

    private static void validateChildPath(String newPath, String fileName, String relativePath, String displayName) throws FilePathTooLongException {
        String fullPath = newPath + File.separator + fileName;
        if (fullPath.length() > 255) {
            String displayPath = PathValidationUtil.buildRelativePath(relativePath, displayName.isEmpty() ? fileName : displayName);
            throw new FilePathTooLongException(fullPath.length(), displayPath, 255);
        }
    }

    private static String buildMetaFilePathFromPath(String path) {
        return path + File.separator + FolderEntity.getMetaDataFileExtension();
    }

    private static String buildRelativePath(String basePath, String name) {
        return basePath + (basePath.isEmpty() ? "" : File.separator) + name;
    }

    private static <T extends FileEntity> List<T> getChildren(FolderEntity folder, Class<T> type) throws Exception {
        return EntityFileServiceManager.getChildren(folder, type);
    }
}

