/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.actions;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatGroovyAction;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatKind;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;

public class KatalonFormatAction
extends FormatGroovyAction {
    public KatalonFormatAction(IWorkbenchSite site, FormatKind kind) {
        super(site, kind);
    }

    public void run(ITextSelection textSelection) {
        if (!(this.getSite() instanceof IEditorSite)) {
            return;
        }
        IWorkbenchPart part = ((IEditorSite)this.getSite()).getPart();
        if (!(part instanceof GroovyEditor)) {
            return;
        }
        GroovyEditor groovyEditor = (GroovyEditor)part;
        IDocument doc = groovyEditor.getDocumentProvider().getDocument((Object)groovyEditor.getEditorInput());
        int selectedOffset = textSelection.getOffset();
        int selectedLength = textSelection.getLength();
        String text = textSelection.getText();
        if (selectedLength == 0) {
            selectedOffset = 0;
            selectedLength = doc.getLength();
            text = doc.get();
        }
        try {
            GroovyWrapperParser parser = new GroovyWrapperParser(new StringBuilder());
            parser.parseGroovyAstIntoScript(GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper(text));
            String newValue = StringUtils.trimToEmpty((String)parser.getValue());
            doc.replace(selectedOffset, selectedLength, newValue);
            groovyEditor.selectAndReveal(selectedOffset, newValue.length());
        }
        catch (MultipleCompilationErrorsException multipleCompilationErrorsException) {
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

