/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.viewer.CustomEditorActivationStrategy;
import com.kms.katalon.composer.components.viewer.FocusCellOwnerDrawHighlighterForMultiSelection;
import com.kms.katalon.composer.testcase.ast.dialogs.AbstractAstBuilderWithTableDialog;
import com.kms.katalon.composer.testcase.ast.dialogs.EncryptedTextDialogCellEditor;
import com.kms.katalon.composer.testcase.ast.editors.EnumPropertyComboBoxCellEditor;
import com.kms.katalon.composer.testcase.ast.editors.StringConstantCellEditor;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.PropertyExpressionWrapper;
import com.kms.katalon.composer.testcase.model.InputParameter;
import com.kms.katalon.composer.testcase.model.InputParameterBuilder;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.providers.AstInputValueLabelProvider;
import com.kms.katalon.composer.testcase.providers.UneditableTableCellLabelProvider;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueColumnSupport;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.composer.testcase.util.AstValueUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ArgumentInputBuilderDialog
extends AbstractAstBuilderWithTableDialog {
    private List<InputParameter> inputParameters;
    private List<InputParameter> originalParameters;
    private ASTNodeWrapper parent;
    protected StringConstantCellEditor valueCellEditor;
    private EncryptedTextDialogCellEditor encryptedTextDialogCellEditor;

    public ArgumentInputBuilderDialog(Shell parentShell, InputParameterBuilder parameterBuilder, ASTNodeWrapper parent) {
        super(parentShell);
        this.originalParameters = parameterBuilder.getOriginalParameters();
        this.parent = parent;
        this.inputParameters = parameterBuilder.getFilteredInputParameters();
    }

    protected void updateTestCaseBindingInputParameters(MethodCallExpressionWrapper testCaseArgument) {
        String testCaseId = AstEntityInputUtil.findTestCaseIdArgumentFromFindTestCaseMethodCall(testCaseArgument);
        if (testCaseId == null) {
            return;
        }
        TestCaseEntity testCase = null;
        try {
            testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseId);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        if (testCase == null) {
            return;
        }
        for (InputParameter input : this.inputParameters) {
            if (!this.isVariablesBindingMapArgument(input)) continue;
            input.setValue(AstEntityInputUtil.generateTestCaseVariableBindingMapExpression(testCase, this.parent));
            this.tableViewer.update((Object)input, null);
        }
    }

    private boolean isVariablesBindingMapArgument(InputParameter input) {
        return input.getParamType() != null && input.getParamType().getFullName().equals(Map.class.getName());
    }

    @Override
    public List<InputParameter> getReturnValue() {
        return this.originalParameters;
    }

    @Override
    public String getDialogTitle() {
        return GlobalMessageConstants.INPUT;
    }

    @Override
    protected void addTableColumns() {
        this.addTableColumnNo();
        this.addTableColumnParam();
        this.addTableColumnParamType();
        this.addTableColumnValueType();
        this.addTableColumnValue();
    }

    private void addTableColumnValue() {
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValue.getColumn().setText(GlobalMessageConstants.VALUE);
        tableViewerColumnValue.getColumn().setWidth(300);
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new ArgumentInputValueLabelProvider());
        tableViewerColumnValue.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer){

            @Override
            protected void setValue(Object element, Object value) {
                Object object = this.inputValueType.changeValue(((InputParameter)element).getValue(), value);
                if (object == null) {
                    return;
                }
                if (!object.equals(element)) {
                    if (object instanceof ASTNodeWrapper && ((InputParameter)element).getValue() instanceof ASTNodeWrapper) {
                        ASTNodeWrapper oldAstNode = (ASTNodeWrapper)((InputParameter)element).getValue();
                        ASTNodeWrapper newAstNode = (ASTNodeWrapper)object;
                        newAstNode.copyProperties(oldAstNode);
                    }
                    ((InputParameter)element).setValue(object);
                    this.getViewer().refresh();
                }
            }

            @Override
            protected Object getValue(Object element) {
                if (((InputParameter)element).isFailureHandlingInputParameter()) {
                    return ((InputParameter)element).getValue();
                }
                return super.getValue(((InputParameter)element).getValue());
            }

            @Override
            protected boolean canEdit(Object element) {
                return element instanceof InputParameter && super.canEdit(((InputParameter)element).getValue());
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                ASTNodeWrapper methodExpressionWrapper;
                if (((InputParameter)element).isFailureHandlingInputParameter()) {
                    return new EnumPropertyComboBoxCellEditor((Composite)this.getViewer().getControl(), FailureHandling.class);
                }
                InputValueType valueType = AstValueUtil.getTypeValue(((InputParameter)element).getValue());
                if (valueType == InputValueType.String && (methodExpressionWrapper = ArgumentInputBuilderDialog.this.parent.getParent()) instanceof MethodCallExpressionWrapper && "setEncryptedText".equals(((MethodCallExpressionWrapper)methodExpressionWrapper).getMethodAsString())) {
                    ArgumentInputBuilderDialog.this.encryptedTextDialogCellEditor = (EncryptedTextDialogCellEditor)AstValueUtil.getCellEditorForEncryptedText((Composite)ArgumentInputBuilderDialog.this.tableViewer.getControl(), (ConstantExpressionWrapper)((InputParameter)element).getValue());
                    return ArgumentInputBuilderDialog.this.encryptedTextDialogCellEditor;
                }
                CellEditor cellEditor = super.getCellEditor(((InputParameter)element).getValue());
                ArgumentInputBuilderDialog.this.valueCellEditor = null;
                if (cellEditor instanceof StringConstantCellEditor) {
                    ArgumentInputBuilderDialog.this.valueCellEditor = (StringConstantCellEditor)cellEditor;
                }
                return cellEditor;
            }
        });
    }

    @Override
    protected void processEditingValueWhenOKPressed() {
        if (this.tableViewer.isCellEditorActive()) {
            if (this.valueCellEditor != null) {
                this.valueCellEditor.applyEditingValue();
            }
            if (this.encryptedTextDialogCellEditor != null) {
                this.encryptedTextDialogCellEditor.applyEditingValue();
            }
        }
    }

    private void addTableColumnValueType() {
        TableViewerColumn tableViewerColumnValueType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValueType.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_VALUE_TYPE);
        tableViewerColumnValueType.getColumn().setWidth(100);
        tableViewerColumnValueType.setLabelProvider((CellLabelProvider)new ArgumentInputValueTypeLabelProvider());
        tableViewerColumnValueType.setEditingSupport((EditingSupport)new MethodArgumentInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer));
    }

    private void addTableColumnParam() {
        TableViewerColumn tableViewerColumnParam = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnParam.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_PARAM);
        tableViewerColumnParam.getColumn().setWidth(100);
        tableViewerColumnParam.setLabelProvider((CellLabelProvider)new UneditableTableCellLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof InputParameter && ((InputParameter)element).getParamName() != null) {
                    return ((InputParameter)element).getParamName();
                }
                return "";
            }
        });
    }

    private void addTableColumnParamType() {
        TableViewerColumn tableViewerColumnParamType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnParamType.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_PARAM_TYPE);
        tableViewerColumnParamType.getColumn().setWidth(100);
        tableViewerColumnParamType.setLabelProvider((CellLabelProvider)new UneditableTableCellLabelProvider(){

            @Override
            public String getText(Object element) {
                if (!(element instanceof InputParameter) || ((InputParameter)element).getParamType() == null) {
                    return "";
                }
                return ((InputParameter)element).getParamType().getDisplayText();
            }
        });
    }

    private void addTableColumnNo() {
        TableViewerColumn tableViewerColumnNo = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnNo.getColumn().setText(GlobalMessageConstants.NO_);
        tableViewerColumnNo.getColumn().setWidth(40);
        tableViewerColumnNo.setLabelProvider((CellLabelProvider)new UneditableTableCellLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof InputParameter) {
                    return Integer.toString(ArgumentInputBuilderDialog.this.inputParameters.indexOf(element) + 1);
                }
                return "";
            }
        });
    }

    @Override
    public void setInput() {
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.inputParameters);
        this.tableViewer.refresh();
    }

    @Override
    protected void setTableActivation(TableViewer tableViewer) {
        if (!"macosx".equals(Platform.getOS())) {
            super.setTableActivation(tableViewer);
            return;
        }
        int activateBitMask = 50;
        FocusCellDialogArgumentBuilderInput focusCellHighlighter = new FocusCellDialogArgumentBuilderInput((ColumnViewer)tableViewer);
        TableViewerEditor.create((TableViewer)tableViewer, (SWTFocusCellManager)new TableViewerFocusCellManager(tableViewer, (FocusCellHighlighter)focusCellHighlighter), (ColumnViewerEditorActivationStrategy)new CustomEditorActivationStrategy((ColumnViewer)tableViewer, (FocusCellOwnerDrawHighlighterForMultiSelection)focusCellHighlighter), (int)activateBitMask);
    }

    private final class ArgumentInputValueLabelProvider
    extends AstInputValueLabelProvider {
        private ArgumentInputValueLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (!(element instanceof InputParameter)) {
                return "";
            }
            InputParameter inputParameter = (InputParameter)element;
            if (inputParameter.isFailureHandlingInputParameter()) {
                return ((PropertyExpressionWrapper)inputParameter.getValue()).getPropertyAsString();
            }
            return super.getText(inputParameter.getValue());
        }
    }

    private final class ArgumentInputValueTypeLabelProvider
    extends StyledCellLabelProvider {
        private ArgumentInputValueTypeLabelProvider() {
        }

        protected String getText(Object element) {
            if (!(element instanceof InputParameter)) {
                return "";
            }
            InputValueType typeValue = AstValueUtil.getTypeValue(((InputParameter)element).getValue());
            if (typeValue != null) {
                return TreeEntityUtil.getReadableKeywordName((String)typeValue.getName());
            }
            return "";
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            cell.setImage(this.getImage(cell.getElement()));
            super.update(cell);
        }

        private Image getImage(Object element) {
            if (!(element instanceof InputParameter)) {
                return null;
            }
            InputParameter inputParameter = (InputParameter)element;
            if (this.isMissingInput(inputParameter) || this.isInputHaveInvalidType(inputParameter)) {
                return ImageConstants.IMG_16_WARN_TABLE_ITEM;
            }
            return null;
        }

        private boolean isMissingInput(InputParameter inputParameter) {
            return inputParameter.getValue() == null;
        }

        private boolean isInputHaveInvalidType(InputParameter inputParameter) {
            InputValueType[] possibleInputValueTypes;
            InputValueType inputValueType = AstValueUtil.getTypeValue(inputParameter.getValue());
            InputValueType[] inputValueTypeArray = possibleInputValueTypes = AstInputValueTypeOptionsProvider.getAssignableInputValueTypes(inputParameter.getParamType());
            int n = possibleInputValueTypes.length;
            int n2 = 0;
            while (n2 < n) {
                InputValueType possibleInputValueType = inputValueTypeArray[n2];
                if (inputValueType == possibleInputValueType) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public String getToolTipText(Object element) {
            if (!(element instanceof InputParameter)) {
                return null;
            }
            InputParameter inputParameter = (InputParameter)element;
            if (this.isMissingInput(inputParameter)) {
                return ComposerTestcaseMessageConstants.LP_WARN_MISSING_ARGUMENT_FOR_METHOD_CALL;
            }
            if (this.isInputHaveInvalidType(inputParameter)) {
                return MessageFormat.format(ComposerTestcaseMessageConstants.LP_WARN_INVALID_ARGUMENT_X_FOR_METHOD_CALL_AVAILALE_ARE_Y, AstValueUtil.getTypeValue(inputParameter.getValue()), ArrayUtils.toString((Object)AstInputValueTypeOptionsProvider.getAssignableInputValueTypes(inputParameter.getParamType())));
            }
            return null;
        }
    }

    private class FocusCellDialogArgumentBuilderInput
    extends FocusCellOwnerDrawHighlighterForMultiSelection {
        public FocusCellDialogArgumentBuilderInput(ColumnViewer viewer) {
            super(viewer);
        }

        protected Color getBackgroundLostFocusCell(ViewerCell cell) {
            Color disableColor = ColorUtil.getUnEditableTableCellBackgroundColor();
            Color backgroundColor = cell.getColumnIndex() <= 2 ? disableColor : null;
            ViewerRow row = cell.getViewerRow();
            int i = 0;
            while (i < row.getColumnCount()) {
                row.getCell(i).setBackground((Color)(i <= 2 ? disableColor : null));
                ++i;
            }
            return backgroundColor;
        }
    }

    private final class MethodArgumentInputBuilderValueTypeColumnSupport
    extends AstInputBuilderValueTypeColumnSupport {
        public MethodArgumentInputBuilderValueTypeColumnSupport(ColumnViewer viewer) {
            super(viewer);
        }

        @Override
        protected void setValue(Object element, Object value) {
            InputValueType oldValueType;
            if (!(value instanceof Integer) || (Integer)value < 0 || (Integer)value >= this.inputValueTypes.length) {
                return;
            }
            InputParameter inputParameter = (InputParameter)element;
            InputValueType newValueType = this.inputValueTypes[(Integer)value];
            if (newValueType == (oldValueType = AstValueUtil.getTypeValue(inputParameter.getValue()))) {
                return;
            }
            ASTNodeWrapper newAstNode = (ASTNodeWrapper)newValueType.getNewValue(ArgumentInputBuilderDialog.this.parent);
            if (newValueType == InputValueType.Property && inputParameter.getParamType().isFailureHandlingTypeClass()) {
                newAstNode = AstKeywordsInputUtil.createPropertyExpressionForClass(inputParameter.getParamType().getSimpleName(), ArgumentInputBuilderDialog.this.parent);
            }
            if (newAstNode == null) {
                return;
            }
            if (inputParameter.getValue() instanceof ASTNodeWrapper) {
                ASTNodeWrapper oldAstNode = (ASTNodeWrapper)inputParameter.getValue();
                newAstNode.copyProperties(oldAstNode);
                newAstNode.setParent(oldAstNode.getParent());
            }
            inputParameter.setValue(newAstNode);
            if (newAstNode instanceof MethodCallExpressionWrapper && ((MethodCallExpressionWrapper)newAstNode).isFindTestCaseMethodCall()) {
                ArgumentInputBuilderDialog.this.updateTestCaseBindingInputParameters((MethodCallExpressionWrapper)newAstNode);
            }
            this.getViewer().refresh();
        }

        @Override
        protected Object getValue(Object element) {
            return super.getValue(((InputParameter)element).getValue());
        }

        @Override
        protected boolean canEdit(Object element) {
            return element instanceof InputParameter && !((InputParameter)element).isFailureHandlingInputParameter();
        }

        @Override
        protected CellEditor getCellEditor(Object element) {
            InputParameter inputParameter = (InputParameter)element;
            this.inputValueTypes = AstInputValueTypeOptionsProvider.getAssignableInputValueTypes(inputParameter.getParamType());
            if (inputParameter.getParamName().equals("strokeKeys")) {
                this.inputValueTypes = AstInputValueTypeOptionsProvider.getInputValueTypeOptions("stroke_keys");
            }
            this.initReadableValueTypeNamesList();
            return super.getCellEditor(inputParameter.getValue());
        }
    }
}

