/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.testcase.ast.dialogs.AbstractAstBuilderWithTableDialog;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BooleanExpressionWrapper;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.providers.AstContentProviderAdapter;
import com.kms.katalon.composer.testcase.providers.AstInputTypeLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstInputValueLabelProvider;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueColumnSupport;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import com.kms.katalon.constants.GlobalMessageConstants;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class BooleanBuilderDialog
extends AbstractAstBuilderWithTableDialog {
    private final InputValueType[] defaultInputValueTypes = AstInputValueTypeOptionsProvider.getInputValueTypeOptions(InputValueType.Boolean);
    private BooleanExpressionWrapper booleanExpression;
    private Button btnReverse;

    public BooleanBuilderDialog(Shell parentShell, BooleanExpressionWrapper booleanExpression) {
        super(parentShell);
        this.booleanExpression = booleanExpression.clone();
    }

    @Override
    protected TableViewer createTable(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.btnReverse = new Button(parent, 32);
        this.btnReverse.setText(ComposerTestcaseMessageConstants.DIA_BTN_REVERSE);
        this.btnReverse.setSelection(this.booleanExpression.isReverse());
        this.btnReverse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BooleanBuilderDialog.this.booleanExpression.setReverse(BooleanBuilderDialog.this.btnReverse.getSelection());
            }
        });
        TableViewer tableViewer = new TableViewer(parent, 67586);
        Table table = tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        table.setHeaderVisible(true);
        return tableViewer;
    }

    @Override
    public void setInput() {
        this.tableViewer.setContentProvider((IContentProvider)new AstContentProviderAdapter(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == BooleanBuilderDialog.this.booleanExpression) {
                    return new Object[]{BooleanBuilderDialog.this.booleanExpression.getExpression()};
                }
                return new Object[0];
            }
        });
        this.tableViewer.setInput((Object)this.booleanExpression);
    }

    @Override
    public BooleanExpressionWrapper getReturnValue() {
        return this.booleanExpression;
    }

    @Override
    public String getDialogTitle() {
        return ComposerTestcaseMessageConstants.DIA_TITLE_CONDITION_INPUT;
    }

    @Override
    protected void addTableColumns() {
        TableViewerColumn tableViewerColumnValueType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValueType.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_VALUE_TYPE);
        tableViewerColumnValueType.getColumn().setWidth(100);
        tableViewerColumnValueType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider());
        tableViewerColumnValueType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer, this.defaultInputValueTypes));
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValue.getColumn().setText(GlobalMessageConstants.VALUE);
        tableViewerColumnValue.getColumn().setWidth(300);
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider());
        tableViewerColumnValue.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer));
    }
}

