/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.variable.operations;

import com.kms.katalon.composer.testcase.parts.TableActionOperator;
import com.kms.katalon.composer.testcase.parts.TestCaseDataBindingPart;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class ClearVariableOperation
extends AbstractOperation {
    private TableActionOperator testCaseVariablePart;
    private TableViewer tableViewer;
    private List<VariableEntity> variableList;
    private List<VariableEntity> deletedVariableList;
    private TableViewer variableBindingTableViewer;
    private List<VariableLink> variableLinks;
    private List<VariableLink> deletedVariableLinks;
    private TestCaseDataBindingPart dataBindingPart;

    public ClearVariableOperation(TableActionOperator testCaseVariablePart) {
        super(ClearVariableOperation.class.getName());
        this.testCaseVariablePart = testCaseVariablePart;
        this.tableViewer = testCaseVariablePart.getTableViewer();
        this.variableList = testCaseVariablePart.getVariablesList();
        this.deletedVariableList = new ArrayList<VariableEntity>();
        if (testCaseVariablePart.getParent() != null) {
            this.dataBindingPart = testCaseVariablePart.getParent().getDataBindingPart();
            this.variableBindingTableViewer = this.dataBindingPart.getVariableBindingTableViewer();
            this.variableLinks = this.dataBindingPart.getVariableLinkList();
            this.deletedVariableLinks = new ArrayList<VariableLink>();
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.deletedVariableList.clear();
        this.deletedVariableList.addAll(this.variableList);
        if (this.deletedVariableLinks != null) {
            this.deletedVariableLinks.clear();
            this.deletedVariableLinks.addAll(this.variableLinks);
        }
        return this.redo(monitor, info);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.variableList.clear();
        this.tableViewer.refresh();
        if (OSUtil.isMacBigSurOrLater()) {
            this.tableViewer.getTable().redraw();
        }
        if (this.variableLinks != null) {
            this.variableLinks.clear();
        }
        this.refreshVariableBindingTable();
        this.testCaseVariablePart.setDirty(true);
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.variableList.addAll(this.deletedVariableList);
        this.tableViewer.refresh();
        if (OSUtil.isMacBigSurOrLater()) {
            this.tableViewer.getTable().redraw();
        }
        this.tableViewer.setSelection((ISelection)new StructuredSelection(this.deletedVariableList.toArray()));
        if (this.variableLinks != null) {
            this.variableLinks.addAll(this.deletedVariableLinks);
        }
        this.refreshVariableBindingTable();
        this.testCaseVariablePart.setDirty(true);
        return Status.OK_STATUS;
    }

    private void refreshVariableBindingTable() {
        if (this.dataBindingPart != null) {
            this.variableBindingTableViewer.refresh();
            this.variableBindingTableViewer.setInput(this.variableLinks);
            if (OSUtil.isMacBigSurOrLater()) {
                this.variableBindingTableViewer.getTable().redraw();
            }
        }
    }
}

