/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.components;

import com.kms.katalon.composer.testcase.components.AbstractKeywordNodeTooltip;
import com.kms.katalon.composer.testcase.components.BuiltinKeywordNodeTooltip;
import com.kms.katalon.composer.testcase.components.CustomKeywordNodeTooltip;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserTreeEntity;
import com.kms.katalon.composer.testcase.util.KeywordURLUtil;
import com.kms.katalon.composer.testcase.util.TestCaseEntityUtil;
import com.kms.katalon.core.keyword.BuiltinKeywords;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class TreeViewerKeywordTooltip {
    private static AbstractKeywordNodeTooltip tip;
    private TreeViewer treeViewer;
    protected static final int SHIFT_X = -10;
    protected static final int SHIFT_Y = 2;
    private String currentKeyword;

    public TreeViewerKeywordTooltip(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        Listener listener = this.createListener();
        treeViewer.getTree().addListener(32, listener);
        treeViewer.getTree().addListener(5, listener);
        treeViewer.getTree().addListener(8, listener);
        treeViewer.getTree().addListener(3, listener);
        treeViewer.getTree().addListener(1, listener);
        treeViewer.getTree().addListener(16, listener);
        treeViewer.getTree().addListener(7, listener);
    }

    private Listener createListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: {
                        if (tip == null) break;
                        TreeViewerKeywordTooltip.this.showTooltip(event.x, event.y);
                        break;
                    }
                    case 32: {
                        TreeViewerKeywordTooltip.this.showTooltip(event.x, event.y);
                        break;
                    }
                    case 3: 
                    case 7: 
                    case 16: {
                        if (TreeViewerKeywordTooltip.this.isMousePosInTooltip(event.x, event.y)) break;
                        TreeViewerKeywordTooltip.this.hideTooltip();
                        break;
                    }
                    default: {
                        TreeViewerKeywordTooltip.this.hideTooltip();
                    }
                }
            }
        };
    }

    protected boolean isMousePosInTooltip(int x, int y) {
        if (tip == null || !tip.isVisible()) {
            return false;
        }
        Point p = this.treeViewer.getTree().toDisplay(new Point(x, y));
        if (x == 0 && y == 0) {
            p = Display.getCurrent().getCursorLocation();
        }
        int shift = tip.isShowBelowPoint() ? 2 : -2;
        Rectangle rect = tip.getBounds();
        return rect.contains(p.x, p.y + shift);
    }

    protected void hideTooltip() {
        if (tip != null) {
            tip.hide();
            tip = null;
        }
    }

    protected AbstractKeywordNodeTooltip getTooltip() {
        return tip;
    }

    protected void setCurrentKeyword(String keyword) {
        this.currentKeyword = keyword;
    }

    protected void showTooltip(int x, int y) {
        Point point = new Point(x, y);
        TreeItem item = this.treeViewer.getTree().getItem(point);
        if (item == null || !(item.getData() instanceof KeywordBrowserTreeEntity)) {
            this.hideTooltip();
            return;
        }
        KeywordBrowserTreeEntity keywordBrowserEntity = (KeywordBrowserTreeEntity)item.getData();
        String classKeyword = keywordBrowserEntity.getClassName();
        String keywordName = keywordBrowserEntity.getName();
        if (tip != null && tip.isVisible() && keywordName != null && keywordName.equals(this.currentKeyword)) {
            return;
        }
        if (tip != null) {
            tip.hide();
        }
        this.currentKeyword = keywordName;
        this.createTooltip(classKeyword, keywordName, this.getParameterTypes(keywordBrowserEntity)).show(this.getTooltipLocation(point));
    }

    private String[] getParameterTypes(KeywordBrowserTreeEntity keywordBrowserEntity) {
        return keywordBrowserEntity.getParameterClassNames() != null ? keywordBrowserEntity.getParameterClassNames() : new String[]{};
    }

    protected AbstractKeywordNodeTooltip createTooltip(String classKeyword, String keyword, String[] parameterTypes) {
        tip = "CustomKeywords".equals(classKeyword) ? new CustomKeywordNodeTooltip((Control)this.treeViewer.getTree(), this.removeQuotes(keyword), parameterTypes) : this.getBuiltinKeywordTooltip(classKeyword, keyword);
        return tip;
    }

    private BuiltinKeywordNodeTooltip getBuiltinKeywordTooltip(String classKeyword, String keyword) {
        BuiltinKeywordNodeTooltip tip = new BuiltinKeywordNodeTooltip((Control)this.treeViewer.getTree());
        if (keyword.equalsIgnoreCase("callTestCase")) {
            classKeyword = BuiltinKeywords.class.getSimpleName();
        }
        tip.setKeywordURL(KeywordURLUtil.getKeywordDescriptionURI(classKeyword, keyword));
        String text = TestCaseEntityUtil.getBuiltinKeywordJavadocText(classKeyword, keyword);
        if (text == null || text.length() < 1) {
            text = keyword;
        }
        tip.setText(text);
        return tip;
    }

    private String removeQuotes(String str) {
        String result = StringUtils.replace((String)str, (String)"'", (String)"");
        result = StringUtils.replace((String)result, (String)"\"", (String)"");
        return result;
    }

    protected String getCurrentKeyword() {
        return this.currentKeyword;
    }

    protected Point getTooltipLocation(Point controlPoint) {
        Point screenPoint = this.treeViewer.getControl().toDisplay(controlPoint);
        screenPoint.x += -10;
        screenPoint.y += 2;
        return screenPoint;
    }

    protected TreeViewer getViewer() {
        return this.treeViewer;
    }

    public boolean isProcessShowTooltip(Event ev) {
        Point point = new Point(ev.x, ev.y);
        TreeItem item = this.treeViewer.getTree().getItem(point);
        return item != null && item.getData() instanceof KeywordBrowserTreeEntity;
    }
}

