/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.dialogs;

import com.kms.katalon.composer.components.impl.control.TreeEntitySelectionComposite;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.explorer.providers.FolderEntityTreeViewerFilter;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TestCaseFolderSelectionDialog
extends AbstractDialog {
    private static final String DEFAULT_DIALOG_NAME = ComposerTestcaseMessageConstants.DIALOG_TITLE_TEST_CASE_FOLDER_SELECTION;
    private TreeEntitySelectionComposite folderTreeComposite;
    private FolderTreeEntity selectedFolder;
    private String dialogName;

    public TestCaseFolderSelectionDialog(Shell parentShell) {
        this(parentShell, null);
    }

    public TestCaseFolderSelectionDialog(Shell parentShell, String dialogName) {
        super(parentShell);
        this.dialogName = !StringUtils.isBlank((CharSequence)dialogName) ? dialogName : DEFAULT_DIALOG_NAME;
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        EntityProvider contentProvider = new EntityProvider();
        this.folderTreeComposite = new TreeEntitySelectionComposite(container, 2048, (ITreeContentProvider)contentProvider, (AbstractEntityViewerFilter)new FolderEntityTreeViewerFilter(contentProvider), (IEntityLabelProvider)new EntityLabelProvider());
        this.folderTreeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout treeLayout = new GridLayout(1, false);
        treeLayout.marginWidth = 0;
        treeLayout.marginHeight = 0;
        this.folderTreeComposite.setLayout((Layout)treeLayout);
        this.folderTreeComposite.getTreeViewer().setAutoExpandLevel(-1);
        return container;
    }

    protected void registerControlModifyListeners() {
        final TreeViewer treeViewer = this.folderTreeComposite.getTreeViewer();
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestCaseFolderSelectionDialog.this.selectedFolderChanged();
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object firstElement;
                treeViewer.setExpandedState(firstElement, !treeViewer.getExpandedState(firstElement = treeViewer.getStructuredSelection().getFirstElement()));
            }
        });
    }

    private void selectedFolderChanged() {
        this.selectedFolder = (FolderTreeEntity)this.folderTreeComposite.getTreeViewer().getStructuredSelection().getFirstElement();
    }

    protected void setInput() {
        try {
            FolderEntity testCaseRoot = FolderController.getInstance().getTestCaseRoot(ProjectController.getInstance().getCurrentProject());
            this.selectedFolder = TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)testCaseRoot, (FolderEntity)testCaseRoot);
            this.folderTreeComposite.setInput(new Object[]{this.selectedFolder});
            this.folderTreeComposite.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)this.selectedFolder));
            this.selectedFolderChanged();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public FolderTreeEntity getSelectedFolder() {
        return this.selectedFolder;
    }

    protected Point getInitialSize() {
        return new Point(500, 400);
    }

    protected boolean isResizable() {
        return true;
    }

    public String getDialogTitle() {
        return this.dialogName;
    }
}

