/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.editors;

import com.kms.katalon.composer.components.dialogs.AbstractDialogCellEditor;
import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.folder.FolderEntity;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public abstract class EntitySelectionDialogCellEditor
extends AbstractDialogCellEditor {
    private ISelectionStatusValidator validator = null;

    public EntitySelectionDialogCellEditor(Composite parent, String defaultContent) {
        super(parent, defaultContent);
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        if (ProjectController.getInstance().getCurrentProject() == null) {
            return null;
        }
        TreeEntitySelectionDialog dialog = new TreeEntitySelectionDialog(Display.getCurrent().getActiveShell(), (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), (AbstractEntityViewerFilter)new EntityViewerFilter(new EntityProvider()));
        dialog.setAllowMultiple(false);
        dialog.setTitle(this.getDialogTitle());
        dialog.setValidator(this.validator);
        FolderEntity rootFolder = this.getRootFolder();
        if (rootFolder == null) {
            return null;
        }
        try {
            dialog.setInput((Object)TreeEntityUtil.getChildren(null, (FolderEntity)rootFolder));
            ITreeEntity initialSelection = this.getInitialSelection();
            if (initialSelection != null) {
                dialog.setInitialSelection((Object)initialSelection);
            }
            if (dialog.open() == 0) {
                return dialog.getFirstResult();
            }
            return null;
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.EDI_ERROR_MSG_CANNOT_OPEN_DIA);
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    public abstract String getDialogTitle();

    public abstract FolderEntity getRootFolder();

    public abstract ITreeEntity getInitialSelection();

    protected void doSetValue(Object value) {
        assert (value instanceof Entity);
        super.doSetValue(value);
    }

    protected Object doGetValue() {
        Object value = super.doGetValue();
        if (!(value instanceof Entity)) {
            return null;
        }
        return value;
    }

    protected void setDialogValidator(ISelectionStatusValidator validator) {
        this.validator = validator;
    }
}

