/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.editors.extensions;

import com.kms.katalon.composer.components.impl.editors.extensions.CodeSelectHelper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.core.manipulation.search.BreakContinueTargetFinder;
import org.eclipse.jdt.internal.core.manipulation.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.core.manipulation.search.SearchMessages;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.CollectionsUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.EnumConstructorTargetFinder;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementHyperlink;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static ITypeRoot fLastInput;
    private static long fLastModStamp;
    private static IRegion fLastWordRegion;
    private static IJavaElement[] fLastElements;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ArrayList<IHyperlink> links;
        block18: {
            IJavaElement[] elements;
            IRegion wordRegion;
            IAction openAction;
            ITextEditor textEditor;
            block17: {
                IEditorInput editorInput;
                IDocumentProvider documentProvider;
                ITypeRoot input;
                block16: {
                    IDocument document;
                    block15: {
                        textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
                        if (region == null || !(textEditor instanceof JavaEditor)) {
                            return null;
                        }
                        openAction = textEditor.getAction("OpenEditor");
                        if (!(openAction instanceof SelectionDispatchAction)) {
                            return null;
                        }
                        int offset = region.getOffset();
                        input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, (boolean)false);
                        if (input == null) {
                            return null;
                        }
                        documentProvider = textEditor.getDocumentProvider();
                        editorInput = textEditor.getEditorInput();
                        document = documentProvider.getDocument((Object)editorInput);
                        wordRegion = JavaWordFinder.findWord((IDocument)document, (int)offset);
                        if (wordRegion != null && wordRegion.getLength() != 0) break block15;
                        return null;
                    }
                    if (!JavaElementHyperlinkDetector.isInheritDoc(document, wordRegion) || ((Object)((Object)this)).getClass() == JavaElementHyperlinkDetector.class) break block16;
                    return null;
                }
                if (JavaElementHyperlinkDetector.class == ((Object)((Object)this)).getClass() && JavaElementHyperlinkDetector.findBreakOrContinueTarget(input, region) != null) {
                    return new IHyperlink[]{new JavaElementHyperlink(wordRegion, (SelectionDispatchAction)openAction, null, false)};
                }
                if (JavaElementHyperlinkDetector.class == ((Object)((Object)this)).getClass() && JavaElementHyperlinkDetector.findSwitchCaseTarget(input, region) != null) {
                    return new IHyperlink[]{new JavaElementHyperlink(wordRegion, (SelectionDispatchAction)openAction, null, false)};
                }
                if (JavaElementHyperlinkDetector.class == ((Object)((Object)this)).getClass() && JavaElementHyperlinkDetector.findEnumConstructorTarget(input, region) != null) {
                    return new IHyperlink[]{new JavaElementHyperlink(wordRegion, (SelectionDispatchAction)openAction, null, false)};
                }
                long modStamp = documentProvider.getModificationStamp((Object)editorInput);
                if (input.equals(fLastInput) && modStamp == fLastModStamp && wordRegion.equals(fLastWordRegion)) {
                    elements = fLastElements;
                } else {
                    CodeSelectHelper selectHelper = new CodeSelectHelper();
                    elements = selectHelper.select((GroovyCompilationUnit)input, wordRegion.getOffset(), wordRegion.getLength());
                    elements = this.selectOpenableElements(elements);
                    fLastInput = input;
                    fLastModStamp = modStamp;
                    fLastWordRegion = wordRegion;
                    fLastElements = elements;
                }
                if (elements.length != 0) break block17;
                return null;
            }
            try {
                links = new ArrayList<IHyperlink>(elements.length);
                IJavaElement[] iJavaElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement element = iJavaElementArray[n2];
                    this.addHyperlinks(links, wordRegion, (SelectionDispatchAction)openAction, element, elements.length > 1, (JavaEditor)textEditor);
                    ++n2;
                }
                if (!links.isEmpty()) break block18;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return (IHyperlink[])CollectionsUtil.toArray(links, IHyperlink.class);
    }

    public void dispose() {
        super.dispose();
        fLastElements = null;
        fLastInput = null;
        fLastWordRegion = null;
    }

    private static boolean isInheritDoc(IDocument document, IRegion wordRegion) {
        try {
            String word = document.get(wordRegion.getOffset(), wordRegion.getLength());
            return "inheritDoc".equals(word);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected void addHyperlinks(List<IHyperlink> hyperlinksCollector, IRegion wordRegion, SelectionDispatchAction openAction, IJavaElement element, boolean qualify, JavaEditor editor) {
        hyperlinksCollector.add((IHyperlink)new JavaElementHyperlink(wordRegion, openAction, element, qualify));
    }

    private IJavaElement[] selectOpenableElements(IJavaElement[] elements) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>(elements.length);
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            switch (element.getElementType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 11: {
                    break;
                }
                default: {
                    result.add(element);
                }
            }
            ++n2;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    public static IOccurrencesFinder.OccurrenceLocation findBreakOrContinueTarget(ITypeRoot input, IRegion region) {
        IOccurrencesFinder.OccurrenceLocation[] locations;
        CompilationUnit astRoot = SharedASTProviderCore.getAST((ITypeRoot)input, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_NO, null);
        if (astRoot == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)astRoot, (int)region.getOffset(), (int)region.getLength());
        ASTNode breakOrContinueNode = null;
        boolean labelSelected = false;
        if (node instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)node;
            StructuralPropertyDescriptor location = simpleName.getLocationInParent();
            if (location == ContinueStatement.LABEL_PROPERTY || location == BreakStatement.LABEL_PROPERTY) {
                breakOrContinueNode = simpleName.getParent();
                labelSelected = true;
            }
        } else if (node instanceof ContinueStatement || node instanceof BreakStatement) {
            breakOrContinueNode = node;
        }
        if (breakOrContinueNode == null) {
            return null;
        }
        BreakContinueTargetFinder finder = new BreakContinueTargetFinder();
        if (finder.initialize(astRoot, breakOrContinueNode) == null && (locations = finder.getOccurrences()) != null) {
            if (breakOrContinueNode instanceof BreakStatement && !labelSelected) {
                return locations[locations.length - 1];
            }
            return locations[0];
        }
        return null;
    }

    public static IOccurrencesFinder.OccurrenceLocation findSwitchCaseTarget(ITypeRoot input, IRegion region) {
        CompilationUnit astRoot = SharedASTProviderCore.getAST((ITypeRoot)input, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_NO, null);
        if (astRoot == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)astRoot, (int)region.getOffset(), (int)region.getLength());
        if (!(node instanceof SwitchCase)) {
            return null;
        }
        SwitchCase caseNode = (SwitchCase)node;
        ASTNode parent = caseNode.getParent();
        if (!(parent instanceof SwitchStatement) && !(parent instanceof SwitchExpression)) {
            return null;
        }
        ASTNode switchNode = parent;
        String description = Messages.format((String)SearchMessages.BreakContinueTargetFinder_occurrence_description, (Object)BasicElementLabels.getJavaElementName((String)ASTNodes.asString((ASTNode)caseNode)));
        return new IOccurrencesFinder.OccurrenceLocation(switchNode.getStartPosition(), 6, 0, description);
    }

    public static IOccurrencesFinder.OccurrenceLocation findEnumConstructorTarget(ITypeRoot input, IRegion region) {
        CompilationUnit astRoot = SharedASTProviderCore.getAST((ITypeRoot)input, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_NO, null);
        return JavaElementHyperlinkDetector.findEnumConstructorTarget(astRoot, region);
    }

    public static IOccurrencesFinder.OccurrenceLocation findEnumConstructorTarget(CompilationUnit astRoot, IRegion region) {
        IOccurrencesFinder.OccurrenceLocation location;
        if (astRoot == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)astRoot, (int)region.getOffset(), (int)region.getLength());
        if (node == null || node.getParent() == null || node.getParent().getNodeType() != 72) {
            return null;
        }
        EnumConstructorTargetFinder finder = new EnumConstructorTargetFinder();
        EnumConstantDeclaration enumNode = (EnumConstantDeclaration)node.getParent();
        if (finder.initialize(astRoot, enumNode) && (location = finder.getOccurrence()) != null) {
            return location;
        }
        String description = Messages.format((String)org.eclipse.jdt.internal.ui.search.SearchMessages.EnumConstructorTargetFinder_description, (Object)BasicElementLabels.getJavaElementName((String)ASTNodes.asString((ASTNode)node)));
        return new IOccurrencesFinder.OccurrenceLocation(enumNode.getStartPosition(), node.getLength(), 0, description);
    }
}

