/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.AnnonatedNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.FieldNode;

public class FieldNodeWrapper
extends AnnonatedNodeWrapper {
    private String name;
    private int modifiers;
    private ClassNodeWrapper type;
    private ExpressionWrapper initialValueExpression;

    public FieldNodeWrapper(String name, Class<?> type, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.name = name;
        this.type = new ClassNodeWrapper(type, (ASTNodeWrapper)this);
        this.modifiers = 1;
    }

    public FieldNodeWrapper(FieldNode fieldNode, ASTNodeWrapper parentNodeWrapper) {
        super((AnnotatedNode)fieldNode, parentNodeWrapper);
        this.name = fieldNode.getName();
        this.modifiers = fieldNode.getModifiers();
        this.type = ClassNodeWrapper.getClassWrapper(fieldNode.getType(), this);
        this.initialValueExpression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(fieldNode.getInitialExpression(), this);
    }

    public FieldNodeWrapper(FieldNodeWrapper fieldNodeWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(fieldNodeWrapper, parentNodeWrapper);
        this.name = fieldNodeWrapper.getName();
        this.modifiers = fieldNodeWrapper.getModifiers();
        this.type = new ClassNodeWrapper(fieldNodeWrapper.getType(), (ASTNodeWrapper)this);
        if (this.initialValueExpression != null) {
            this.initialValueExpression = fieldNodeWrapper.getInitialValueExpression().copy(this);
        }
    }

    public FieldNodeWrapper(FieldNodeWrapper fieldNodeWrapper) {
        this(fieldNodeWrapper, fieldNodeWrapper.getParent());
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public ExpressionWrapper getInitialValueExpression() {
        return this.initialValueExpression;
    }

    public void setInitialValueExpression(ExpressionWrapper initialValueExpression) {
        if (initialValueExpression == null) {
            return;
        }
        initialValueExpression.setParent(this);
        this.initialValueExpression = initialValueExpression;
    }

    public ClassNodeWrapper getType() {
        return this.type;
    }

    @Override
    public String getText() {
        return this.name;
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<? extends ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.addAll(super.getAstChildren());
        astNodeWrappers.add(this.initialValueExpression);
        return astNodeWrappers;
    }

    @Override
    public FieldNodeWrapper clone() {
        return new FieldNodeWrapper(this, this.getParent());
    }
}

