/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;

public class ImportNodeCompatibilityWrapper {
    private ModuleNode module;
    private List<ImportNode> sortedImports;

    public ImportNodeCompatibilityWrapper(ModuleNode module) {
        if (module == null) {
            throw new IllegalArgumentException("Module node should not be null");
        }
        this.module = module;
    }

    public List<ImportNode> getAllImportNodes() {
        Comparator importNodeComparator = (n1, n2) -> {
            if (n1 == n2) {
                return 0;
            }
            if (n1 == null) {
                return -1;
            }
            if (n2 == null) {
                return 1;
            }
            return n1.getClassName().compareTo(n2.getClassName());
        };
        if (this.sortedImports == null) {
            this.sortedImports = new ArrayList<ImportNode>();
            this.sortedImports.addAll(this.module.getImports());
            this.sortedImports.addAll(this.module.getStarImports());
            this.sortedImports.addAll(this.module.getStaticImports().values());
            this.sortedImports.addAll(this.module.getStaticStarImports().values());
            Collections.sort(this.sortedImports, importNodeComparator);
            this.sortedImports = Collections.unmodifiableList(this.sortedImports);
        }
        return this.sortedImports;
    }

    public static String getFieldName(ImportNode node) {
        return node.getFieldName();
    }

    public static Map<String, ImportNode> getStaticImports(ModuleNode node) {
        return node.getStaticImports();
    }

    public static Map<String, ImportNode> getStaticStarImports(ModuleNode node) {
        return node.getStaticStarImports();
    }

    public static List<ImportNode> getStarImports(ModuleNode node) {
        return node.getStarImports();
    }
}

