/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTWrapperConverter;
import com.kms.katalon.composer.testcase.groovy.ast.statements.AssertStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BlockStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BreakStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ContinueStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.DoWhileStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ForStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.IfStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ReturnStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.SwitchStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.SynchronizedStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ThrowStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.TryCatchStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.WhileStatementWrapper;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;

public class StatementWrapHelper {
    private static Map<String, StatementWrapperConverter<? extends Statement>> statementWrapperConverterMap;
    private static final StatementWrapperConverter<BlockStatement> blockStatementWrapperConverter;
    private static final StatementWrapperConverter<ExpressionStatement> expressionStatementWrapperConverter;
    private static final StatementWrapperConverter<ReturnStatement> returnStatementWrapperConverter;
    private static final StatementWrapperConverter<AssertStatement> assertStatementWrapperConverter;
    private static final StatementWrapperConverter<SwitchStatement> switchStatementWrapperConverter;
    private static final StatementWrapperConverter<ThrowStatement> throwStatementWrapperConverter;
    private static final StatementWrapperConverter<TryCatchStatement> tryCatchStatementWrapperConverter;
    private static final StatementWrapperConverter<IfStatement> ifStatementWrapperConverter;
    private static final StatementWrapperConverter<ForStatement> forStatementWrapperConverter;
    private static final StatementWrapperConverter<WhileStatement> whileStatementWrapperConverter;
    private static final StatementWrapperConverter<DoWhileStatement> doWhileStatementWrapperConverter;
    private static final StatementWrapperConverter<SynchronizedStatement> synchronizedStatementWrapperConverter;
    private static final StatementWrapperConverter<ContinueStatement> continueStatementWrapperConverter;
    private static final StatementWrapperConverter<BreakStatement> breakStatementWrapperConverter;

    static {
        blockStatementWrapperConverter = new StatementWrapperConverter<BlockStatement>(){

            public BlockStatementWrapper wrap(BlockStatement node, ASTNodeWrapper parentNode) {
                return new BlockStatementWrapper(node, parentNode);
            }
        };
        expressionStatementWrapperConverter = new StatementWrapperConverter<ExpressionStatement>(){

            public ExpressionStatementWrapper wrap(ExpressionStatement node, ASTNodeWrapper parentNode) {
                return new ExpressionStatementWrapper(node, parentNode);
            }
        };
        returnStatementWrapperConverter = new StatementWrapperConverter<ReturnStatement>(){

            public ReturnStatementWrapper wrap(ReturnStatement node, ASTNodeWrapper parentNode) {
                return new ReturnStatementWrapper(node, parentNode);
            }
        };
        assertStatementWrapperConverter = new StatementWrapperConverter<AssertStatement>(){

            public AssertStatementWrapper wrap(AssertStatement node, ASTNodeWrapper parentNode) {
                return new AssertStatementWrapper(node, parentNode);
            }
        };
        switchStatementWrapperConverter = new StatementWrapperConverter<SwitchStatement>(){

            public SwitchStatementWrapper wrap(SwitchStatement node, ASTNodeWrapper parentNode) {
                return new SwitchStatementWrapper(node, parentNode);
            }
        };
        throwStatementWrapperConverter = new StatementWrapperConverter<ThrowStatement>(){

            public ThrowStatementWrapper wrap(ThrowStatement node, ASTNodeWrapper parentNode) {
                return new ThrowStatementWrapper(node, parentNode);
            }
        };
        tryCatchStatementWrapperConverter = new StatementWrapperConverter<TryCatchStatement>(){

            public TryCatchStatementWrapper wrap(TryCatchStatement node, ASTNodeWrapper parentNode) {
                return new TryCatchStatementWrapper(node, parentNode);
            }
        };
        ifStatementWrapperConverter = new StatementWrapperConverter<IfStatement>(){

            public IfStatementWrapper wrap(IfStatement node, ASTNodeWrapper parentNode) {
                return new IfStatementWrapper(node, parentNode);
            }
        };
        forStatementWrapperConverter = new StatementWrapperConverter<ForStatement>(){

            public ForStatementWrapper wrap(ForStatement node, ASTNodeWrapper parentNode) {
                return new ForStatementWrapper(node, parentNode);
            }
        };
        whileStatementWrapperConverter = new StatementWrapperConverter<WhileStatement>(){

            public WhileStatementWrapper wrap(WhileStatement node, ASTNodeWrapper parentNode) {
                return new WhileStatementWrapper(node, parentNode);
            }
        };
        doWhileStatementWrapperConverter = new StatementWrapperConverter<DoWhileStatement>(){

            public DoWhileStatementWrapper wrap(DoWhileStatement node, ASTNodeWrapper parentNode) {
                return new DoWhileStatementWrapper(node, parentNode);
            }
        };
        synchronizedStatementWrapperConverter = new StatementWrapperConverter<SynchronizedStatement>(){

            public SynchronizedStatementWrapper wrap(SynchronizedStatement node, ASTNodeWrapper parentNode) {
                return new SynchronizedStatementWrapper(node, parentNode);
            }
        };
        continueStatementWrapperConverter = new StatementWrapperConverter<ContinueStatement>(){

            public ContinueStatementWrapper wrap(ContinueStatement node, ASTNodeWrapper parentNode) {
                return new ContinueStatementWrapper(node, parentNode);
            }
        };
        breakStatementWrapperConverter = new StatementWrapperConverter<BreakStatement>(){

            public BreakStatementWrapper wrap(BreakStatement node, ASTNodeWrapper parentNode) {
                return new BreakStatementWrapper(node, parentNode);
            }
        };
        StatementWrapHelper.initStatementWrapperConverterMap();
    }

    private static void initStatementWrapperConverterMap() {
        statementWrapperConverterMap = new HashMap<String, StatementWrapperConverter<? extends Statement>>();
        statementWrapperConverterMap.put(BlockStatement.class.getSimpleName(), blockStatementWrapperConverter);
        statementWrapperConverterMap.put(ExpressionStatement.class.getSimpleName(), expressionStatementWrapperConverter);
        statementWrapperConverterMap.put(ReturnStatement.class.getSimpleName(), returnStatementWrapperConverter);
        statementWrapperConverterMap.put(AssertStatement.class.getSimpleName(), assertStatementWrapperConverter);
        statementWrapperConverterMap.put(SwitchStatement.class.getSimpleName(), switchStatementWrapperConverter);
        statementWrapperConverterMap.put(ThrowStatement.class.getSimpleName(), throwStatementWrapperConverter);
        statementWrapperConverterMap.put(TryCatchStatement.class.getSimpleName(), tryCatchStatementWrapperConverter);
        statementWrapperConverterMap.put(IfStatement.class.getSimpleName(), ifStatementWrapperConverter);
        statementWrapperConverterMap.put(ForStatement.class.getSimpleName(), forStatementWrapperConverter);
        statementWrapperConverterMap.put(WhileStatement.class.getSimpleName(), whileStatementWrapperConverter);
        statementWrapperConverterMap.put(DoWhileStatement.class.getSimpleName(), doWhileStatementWrapperConverter);
        statementWrapperConverterMap.put(SynchronizedStatement.class.getSimpleName(), synchronizedStatementWrapperConverter);
        statementWrapperConverterMap.put(ContinueStatement.class.getSimpleName(), continueStatementWrapperConverter);
        statementWrapperConverterMap.put(BreakStatement.class.getSimpleName(), breakStatementWrapperConverter);
    }

    public static <T extends Statement> StatementWrapper wrap(T statement, ASTNodeWrapper parentNode) {
        StatementWrapperConverter<? extends Statement> provider = statementWrapperConverterMap.get(statement.getClass().getSimpleName());
        if (provider != null) {
            return provider.wrap(statement, parentNode);
        }
        return null;
    }

    static interface StatementWrapperConverter<T extends Statement>
    extends ASTWrapperConverter<T> {
        @Override
        public StatementWrapper wrap(T var1, ASTNodeWrapper var2);
    }
}

