/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.statements;

import com.kms.katalon.composer.testcase.groovy.ast.ASTHasBlock;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BooleanExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BlockStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ComplexStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ElseIfStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ElseStatementWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class IfStatementWrapper
extends ComplexStatementWrapper<ElseIfStatementWrapper, ElseStatementWrapper>
implements ASTHasBlock {
    private BlockStatementWrapper block = new BlockStatementWrapper(this);
    private BooleanExpressionWrapper expression;

    public IfStatementWrapper() {
        this(null);
    }

    public IfStatementWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.expression = new BooleanExpressionWrapper(this);
    }

    public IfStatementWrapper(BooleanExpressionWrapper booleanExpression, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.expression = new BooleanExpressionWrapper(booleanExpression, (ASTNodeWrapper)this);
    }

    public IfStatementWrapper(IfStatement ifStatement, ASTNodeWrapper parentNodeWrapper) {
        super((Statement)ifStatement, parentNodeWrapper);
        this.expression = new BooleanExpressionWrapper(ifStatement.getBooleanExpression(), (ASTNodeWrapper)this);
        this.block = new BlockStatementWrapper(IfStatementWrapper.initIfBlock(ifStatement), (ASTNodeWrapper)this);
        this.getStatementNodeWrappersFromIfStatement(ifStatement.getElseBlock());
    }

    private static BlockStatement initIfBlock(IfStatement ifStatement) {
        Statement ifBlock = ifStatement.getIfBlock();
        if (ifBlock instanceof BlockStatement) {
            return (BlockStatement)ifBlock;
        }
        BlockStatement block = new BlockStatement();
        block.addStatement(ifBlock);
        return block;
    }

    public IfStatementWrapper(IfStatementWrapper ifStatementWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(ifStatementWrapper, parentNodeWrapper);
        this.expression = new BooleanExpressionWrapper(ifStatementWrapper.getBooleanExpression(), (ASTNodeWrapper)this);
        this.block = new BlockStatementWrapper(ifStatementWrapper.getBlock(), (ASTNodeWrapper)this);
    }

    private void getStatementNodeWrappersFromIfStatement(Statement statement) {
        if (statement instanceof EmptyStatement) {
            return;
        }
        if (statement instanceof IfStatement) {
            IfStatement elseIfStatement = (IfStatement)statement;
            this.addComplexChildStatement(new ElseIfStatementWrapper(elseIfStatement, this));
            this.getStatementNodeWrappersFromIfStatement(elseIfStatement.getElseBlock());
            return;
        }
        if (statement instanceof BlockStatement) {
            this.setLastStatement(new ElseStatementWrapper((BlockStatement)statement, this));
            return;
        }
        BlockStatement block = new BlockStatement();
        block.addStatement(statement);
        this.setLastStatement(new ElseStatementWrapper(block, this));
    }

    public BooleanExpressionWrapper getBooleanExpression() {
        return this.expression;
    }

    public void setBooleanExpression(BooleanExpressionWrapper booleanExpression) {
        if (booleanExpression == null) {
            return;
        }
        booleanExpression.setParent(this);
        this.expression = booleanExpression;
    }

    @Override
    public String getText() {
        return "if (" + this.getInputText() + ")";
    }

    @Override
    public IfStatementWrapper clone() {
        return new IfStatementWrapper(this, this.getParent());
    }

    @Override
    public BlockStatementWrapper getBlock() {
        return this.block;
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.expression);
        astNodeWrappers.add(this.block);
        return astNodeWrappers;
    }

    @Override
    public BooleanExpressionWrapper getInput() {
        return this.getBooleanExpression();
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public String getInputText() {
        return this.getBooleanExpression().getText();
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (input instanceof BooleanExpressionWrapper && !this.getBooleanExpression().isEqualsTo(input)) {
            this.setBooleanExpression((BooleanExpressionWrapper)input);
            return true;
        }
        return false;
    }

    @Override
    public boolean isChildAssignble(ASTNodeWrapper nodeWrapper) {
        return nodeWrapper instanceof ElseIfStatementWrapper || nodeWrapper instanceof ElseStatementWrapper || this.getBlock().isChildAssignble(nodeWrapper);
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject) {
        if (childObject instanceof ElseIfStatementWrapper) {
            this.addComplexChildStatement((ElseIfStatementWrapper)childObject);
            return true;
        }
        if (childObject instanceof ElseStatementWrapper) {
            return this.setLastStatement((ElseStatementWrapper)childObject);
        }
        return this.getBlock().addChild(childObject);
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject, int index) {
        if (childObject instanceof ElseIfStatementWrapper) {
            return this.addComplexChildStatement((ElseIfStatementWrapper)childObject, index);
        }
        if (childObject instanceof ElseStatementWrapper) {
            return this.setLastStatement((ElseStatementWrapper)childObject);
        }
        return this.getBlock().addChild(childObject, index);
    }

    @Override
    public boolean removeChild(ASTNodeWrapper childObject) {
        if (childObject instanceof ElseIfStatementWrapper) {
            return this.removeComplexChildStatement((ElseIfStatementWrapper)childObject);
        }
        if (childObject == this.lastStatement) {
            return this.removeLastStatement();
        }
        return this.getBlock().removeChild(childObject);
    }

    @Override
    public int indexOf(ASTNodeWrapper childObject) {
        if (childObject instanceof ElseIfStatementWrapper) {
            return this.indexOf((ElseIfStatementWrapper)childObject);
        }
        if (childObject == this.lastStatement) {
            return 0;
        }
        return this.getBlock().indexOf(childObject);
    }
}

