/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.statements;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.stmt.Statement;

public abstract class StatementWrapper
extends ASTNodeWrapper {
    public static final String TEXT = "Statement";
    public static final String NOT_RUN_LABEL = "not_run";
    protected String description = "";
    protected String label;

    public StatementWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
    }

    public StatementWrapper(StatementWrapper statementWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(statementWrapper, parentNodeWrapper);
        this.description = statementWrapper.getDescription();
        this.label = statementWrapper.getLabel();
    }

    public StatementWrapper(Statement statement, ASTNodeWrapper parentNodeWrapper) {
        super((ASTNode)statement, parentNodeWrapper);
        this.label = statement.getStatementLabel();
    }

    public boolean canHaveDescription() {
        return true;
    }

    public boolean hasDescription() {
        return !StringUtils.isEmpty((String)this.description);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean setDescription(String description) {
        if (description == null || StringUtils.equals((String)description, (String)this.description)) {
            return false;
        }
        this.description = description;
        return true;
    }

    @Override
    public String getText() {
        return TEXT;
    }

    @Override
    public abstract StatementWrapper clone();

    @Override
    public StatementWrapper copy(ASTNodeWrapper newParent) {
        return (StatementWrapper)super.copy(newParent);
    }

    @Override
    public boolean hasAstChildren() {
        return false;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        return Collections.emptyList();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean canHaveLabel() {
        return true;
    }

    public boolean disable() {
        if (!this.isDisabled()) {
            this.setLabel(NOT_RUN_LABEL);
            return true;
        }
        return false;
    }

    public boolean enable() {
        if (this.isDisabled()) {
            this.setLabel(null);
            return true;
        }
        return false;
    }

    public void toogleEnable() {
        if (this.isDisabled()) {
            this.enable();
            return;
        }
        this.disable();
    }

    public boolean isDisabled() {
        return StringUtils.equals((String)this.label, (String)NOT_RUN_LABEL);
    }
}

