/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.statements;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BooleanExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.CompositeStatementWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.WhileStatement;

public class WhileStatementWrapper
extends CompositeStatementWrapper {
    private BooleanExpressionWrapper booleanExpression;

    public WhileStatementWrapper() {
        this(null);
    }

    public WhileStatementWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.booleanExpression = new BooleanExpressionWrapper(this);
    }

    public WhileStatementWrapper(WhileStatement whileStatement, ASTNodeWrapper parentNodeWrapper) {
        super((Statement)whileStatement, WhileStatementWrapper.initLoopBlock(whileStatement), parentNodeWrapper);
        this.booleanExpression = new BooleanExpressionWrapper(whileStatement.getBooleanExpression(), (ASTNodeWrapper)this);
    }

    public WhileStatementWrapper(WhileStatementWrapper whileStatementWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(whileStatementWrapper, parentNodeWrapper);
        this.booleanExpression = new BooleanExpressionWrapper(whileStatementWrapper.getBooleanExpression(), (ASTNodeWrapper)this);
    }

    private static BlockStatement initLoopBlock(WhileStatement whileStatement) {
        Statement loopBlock = whileStatement.getLoopBlock();
        if (loopBlock instanceof BlockStatement) {
            return (BlockStatement)loopBlock;
        }
        BlockStatement block = new BlockStatement();
        block.addStatement(loopBlock);
        return block;
    }

    public BooleanExpressionWrapper getBooleanExpression() {
        return this.booleanExpression;
    }

    public void setBooleanExpression(BooleanExpressionWrapper booleanExpression) {
        if (booleanExpression == null) {
            return;
        }
        booleanExpression.setParent(this);
        this.booleanExpression = booleanExpression;
    }

    @Override
    public String getText() {
        return "while (" + this.getBooleanExpression().getText() + ")";
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<? extends ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.booleanExpression);
        astNodeWrappers.addAll(super.getAstChildren());
        return astNodeWrappers;
    }

    @Override
    public WhileStatementWrapper clone() {
        return new WhileStatementWrapper(this, this.getParent());
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this.getBooleanExpression();
    }

    @Override
    public String getInputText() {
        return this.getInput().getText();
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (input instanceof BooleanExpressionWrapper && !this.getBooleanExpression().isEqualsTo(input)) {
            this.setBooleanExpression((BooleanExpressionWrapper)input);
            return true;
        }
        return false;
    }
}

