/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.keywords;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.keywords.IKeywordBrowserTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserFolderTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserTreeEntity;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.annotation.Keyword;
import com.kms.katalon.custom.parser.CustomKeywordParser;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;

public class CustomKeywordFolderBrowserTreeEntity
extends KeywordBrowserFolderTreeEntity {
    private static final long serialVersionUID = 1L;
    private static final String KEYWORD_OBJECT_ANNOTATION_METHOD = "keywordObject";
    private static final String TREE_ITEM_LABEL = ComposerTestcaseMessageConstants.KEYWORD_BROWSER_CUSTOM_KEYWORD_ROOT_TREE_ITEM_LABEL;
    private static final String CUSTOM_KEYWORD_CLASS_NAME = "CustomKeywords";

    public CustomKeywordFolderBrowserTreeEntity(IKeywordBrowserTreeEntity parent) {
        super(TREE_ITEM_LABEL, parent);
    }

    @Override
    public boolean hasChildren() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        return currentProject != null && !KeywordController.getInstance().getCustomKeywords(currentProject).isEmpty();
    }

    @Override
    public Object[] getChildren() {
        try {
            return this.getKeywordByKeywordObject().toArray();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    private List<IKeywordBrowserTreeEntity> getKeywordByKeywordObject() throws Exception {
        ArrayList<IKeywordBrowserTreeEntity> childTreeEntityList = new ArrayList<IKeywordBrowserTreeEntity>();
        ProjectController projectController = ProjectController.getInstance();
        ProjectEntity currentProject = projectController.getCurrentProject();
        if (currentProject != null) {
            URLClassLoader classLoader = projectController.getProjectClassLoader(currentProject);
            IFolder srcFolder = GroovyUtil.getCustomKeywordSourceFolder((ProjectEntity)currentProject);
            IFolder pluginFolder = GroovyUtil.getPluginsFolder((ProjectEntity)currentProject);
            List allKeywordMethods = CustomKeywordParser.getInstance().parseProjectCustomKeywordsIntoAst(classLoader, srcFolder);
            allKeywordMethods.addAll(CustomKeywordParser.getInstance().parsePluginKeywordsIntoAst(classLoader, pluginFolder));
            for (File customKeywordPlugin : projectController.getCustomKeywordPlugins(currentProject)) {
                allKeywordMethods.addAll(CustomKeywordParser.getInstance().parsePluginKeywordJarIntoAst(classLoader, customKeywordPlugin));
            }
            HashMap<String, ArrayList<Method>> methodActionMap = new HashMap<String, ArrayList<Method>>();
            for (Method method : allKeywordMethods) {
                String keywordObjectParameter = this.getKeywordObject(method);
                if (!StringUtils.isNotBlank((CharSequence)keywordObjectParameter)) continue;
                ArrayList<Method> methodList = (ArrayList<Method>)methodActionMap.get(keywordObjectParameter);
                if (methodList == null) {
                    methodList = new ArrayList<Method>();
                    methodActionMap.put(keywordObjectParameter, methodList);
                }
                methodList.add(method);
            }
            ArrayList<String> listFolder = new ArrayList<String>();
            for (Map.Entry pair : methodActionMap.entrySet()) {
                KeywordBrowserFolderTreeEntity keywordFolder = new KeywordBrowserFolderTreeEntity((String)pair.getKey(), this);
                for (Method currentMethod : (List)pair.getValue()) {
                    keywordFolder.children.add(new KeywordBrowserTreeEntity(CUSTOM_KEYWORD_CLASS_NAME, CUSTOM_KEYWORD_CLASS_NAME, "'" + currentMethod.getDeclaringClass().getName() + "." + currentMethod.getName() + "'", currentMethod.getParameterTypes(), true, keywordFolder));
                }
                keywordFolder.children.sort(Comparator.comparing(IKeywordBrowserTreeEntity::getName));
                if (listFolder.contains(pair.getKey())) {
                    KeywordBrowserFolderTreeEntity existedKeywordFolder = (KeywordBrowserFolderTreeEntity)this.children.get(listFolder.indexOf(pair.getKey()));
                    existedKeywordFolder.appendNewChild(keywordFolder);
                    continue;
                }
                listFolder.add((String)pair.getKey());
                childTreeEntityList.add(keywordFolder);
            }
        }
        childTreeEntityList.sort(Comparator.comparing(IKeywordBrowserTreeEntity::getName));
        return childTreeEntityList;
    }

    private String getKeywordObject(Method method) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Annotation[] annotationArray = method.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().getName().equals(Keyword.class.getName())) {
                return (String)annotation.annotationType().getMethod(KEYWORD_OBJECT_ANNOTATION_METHOD, new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            ++n2;
        }
        return null;
    }
}

