/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.parts;

import com.kms.katalon.composer.components.impl.constants.TextContentType;
import com.kms.katalon.composer.components.impl.editors.MirrorEditor;
import com.kms.katalon.composer.components.impl.handler.DocumentReadyHandler;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.parts.CPart;
import com.kms.katalon.composer.testcase.parts.IVariablePart;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.entity.variable.VariableEntityWrapper;
import java.util.List;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TestCaseVariableEditorView
extends CPart {
    Composite composite;
    MirrorEditor mirrorEditor;
    boolean contentChanged = false;
    IVariablePart variablePart;
    String contentScript = "";
    Composite parentTestCaseCompositePart;

    public TestCaseVariableEditorView(IVariablePart variablePart, Composite parent) {
        this.variablePart = variablePart;
        this.parentTestCaseCompositePart = parent;
        this.createComponents(parent);
    }

    public void createComponents(Composite variableEditorPartComposite) {
        this.composite = new Composite(variableEditorPartComposite, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.composite.setBackground(ColorUtil.getExtraLightGrayBackgroundColor());
        this.mirrorEditor = new MirrorEditor(this.composite, 0);
        this.mirrorEditor.setEditable(true);
        this.mirrorEditor.registerDocumentHandler(new DocumentReadyHandler(){

            public void onDocumentReady() {
                TestCaseVariableEditorView.this.mirrorEditor.changeMode(TextContentType.XML.getText());
            }
        });
        this.mirrorEditor.addListener(24, event -> {
            if (!this.contentChanged) {
                this.contentChanged = true;
            } else {
                this.setDirty(true);
            }
        });
    }

    private void setDirty(boolean b) {
        this.variablePart.setDirty(b);
    }

    public void setScriptContentFrom(VariableEntityWrapper entityWrapper) throws Exception {
        String incomingContentScript = this.getScriptContentFromVariableEntityWrapper(entityWrapper);
        if (!this.contentScript.equals(incomingContentScript)) {
            this.mirrorEditor.setText(incomingContentScript);
            if (!this.contentScript.equals("")) {
                this.contentChanged = true;
            }
            this.contentScript = incomingContentScript;
        }
    }

    public String getScriptContentFromVariableEntityWrapper(VariableEntityWrapper entityWrapper) throws Exception {
        String content = "";
        if (entityWrapper != null && entityWrapper.getVariables() != null && entityWrapper.getVariables().size() != 0) {
            List incomingVariablesList = entityWrapper.getVariables();
            VariableEntityWrapper variableEntityWrapper = new VariableEntityWrapper();
            variableEntityWrapper.setVariables(incomingVariablesList);
            content = GlobalVariableController.toXmlString((Object)variableEntityWrapper);
        }
        return content;
    }

    public String getScriptContent() {
        return this.mirrorEditor.getText();
    }
}

