/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.support;

import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.util.AstValueUtil;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;

public class AstInputBuilderValueTypeColumnSupport
extends EditingSupport {
    protected InputValueType[] inputValueTypes;
    protected String[] readableValueTypeNames;
    protected String customTag;

    public AstInputBuilderValueTypeColumnSupport(ColumnViewer viewer, InputValueType[] defaultInputValueTypes) {
        super(viewer);
        this.inputValueTypes = defaultInputValueTypes;
        this.initReadableValueTypeNamesList();
    }

    protected void initReadableValueTypeNamesList() {
        this.readableValueTypeNames = new String[this.inputValueTypes.length];
        int i = 0;
        while (i < this.inputValueTypes.length) {
            this.readableValueTypeNames[i] = TreeEntityUtil.getReadableKeywordName((String)this.inputValueTypes[i].getName());
            ++i;
        }
    }

    protected AstInputBuilderValueTypeColumnSupport(ColumnViewer viewer) {
        super(viewer);
    }

    protected void setValue(Object element, Object value) {
        if (!(value instanceof Integer) || (Integer)value < 0 || (Integer)value >= this.inputValueTypes.length) {
            return;
        }
        ASTNodeWrapper oldAstNode = (ASTNodeWrapper)element;
        ASTNodeWrapper parentNode = oldAstNode.getParent();
        if (parentNode == null) {
            return;
        }
        ASTNodeWrapper newAstNode = this.getNewAstNode(value, oldAstNode);
        if (newAstNode == null) {
            return;
        }
        newAstNode.copyProperties(oldAstNode);
        if (parentNode.replaceChild(oldAstNode, newAstNode)) {
            this.getViewer().refresh();
        }
    }

    protected ASTNodeWrapper getNewAstNode(Object value, ASTNodeWrapper oldAstNode) {
        InputValueType oldValueType;
        InputValueType newValueType = this.inputValueTypes[(Integer)value];
        if (newValueType == (oldValueType = AstValueUtil.getTypeValue(oldAstNode))) {
            return null;
        }
        return (ASTNodeWrapper)newValueType.getNewValue(oldAstNode.getParent());
    }

    protected Object getValue(Object element) {
        InputValueType valueType = AstValueUtil.getTypeValue((ASTNodeWrapper)element);
        if (valueType == null) {
            return 0;
        }
        int index = 0;
        while (index < this.inputValueTypes.length) {
            if (valueType.equals(this.inputValueTypes[index])) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    protected CellEditor getCellEditor(Object element) {
        return new ComboBoxCellEditor((Composite)this.getViewer().getControl(), this.readableValueTypeNames);
    }

    protected boolean canEdit(Object element) {
        return element instanceof ASTNodeWrapper;
    }
}

