/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.support;

import com.kms.katalon.composer.components.impl.editors.VariableTestDataLinkCellEditor;
import com.kms.katalon.composer.testcase.parts.TestCasePartDataBindingView;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.VariableLink;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class VariableTestDataLinkColumnEditingSupport
extends EditingSupport {
    private TestCasePartDataBindingView testDataView;

    public VariableTestDataLinkColumnEditingSupport(ColumnViewer viewer, TestCasePartDataBindingView testDataView) {
        super(viewer);
        this.testDataView = testDataView;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element == null || !(element instanceof VariableLink)) {
            return null;
        }
        List<TestCaseTestDataLink> testCaseLink = this.testDataView.getTestCaseTestDataLinks();
        if (testCaseLink == null) {
            return null;
        }
        VariableLink variableLink = (VariableLink)element;
        String testDataLinkId = variableLink.getTestDataLinkId();
        TestCaseTestDataLink testData = this.getTestCaseTestDataLink(testDataLinkId);
        return new VariableTestDataLinkCellEditor((Composite)this.getViewer().getControl(), testCaseLink, testData);
    }

    private TestCaseTestDataLink getTestCaseTestDataLink(String id) {
        for (TestCaseTestDataLink link : this.testDataView.getTestCaseTestDataLinks()) {
            if (!link.getId().equals(id)) continue;
            return link;
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        if (!(element instanceof VariableLink)) {
            return false;
        }
        VariableLink variableLink = (VariableLink)element;
        return variableLink.getType() == VariableLink.VariableType.DATA_COLUMN || variableLink.getType() == VariableLink.VariableType.DATA_COLUMN_INDEX;
    }

    protected Object getValue(Object element) {
        if (!(element instanceof VariableLink)) {
            return "";
        }
        VariableLink variableLink = (VariableLink)element;
        String testDataLinkId = variableLink.getTestDataLinkId();
        if (testDataLinkId == null || testDataLinkId.isEmpty()) {
            return "";
        }
        TestCaseTestDataLink testDataLink = this.getTestCaseTestDataLink(testDataLinkId);
        return testDataLink != null ? testDataLink.getTestDataId() : "";
    }

    protected void setValue(Object element, Object value) {
        if (element == null || !(element instanceof VariableLink) || value == null || !(value instanceof TestCaseTestDataLink)) {
            return;
        }
        VariableLink variableLink = (VariableLink)element;
        TestCaseTestDataLink dataLinkTreeNode = (TestCaseTestDataLink)value;
        if (!dataLinkTreeNode.getId().equals(variableLink.getTestDataLinkId())) {
            variableLink.setTestDataLinkId(dataLinkTreeNode.getId());
            variableLink.setValue("");
            this.getViewer().update(element, null);
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)variableLink));
            this.testDataView.setDirty(true);
            this.testDataView.refreshVariableBindingTable();
        }
    }
}

