/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.util;

import com.google.common.collect.ImmutableMap;
import com.kms.katalon.composer.testcase.model.InputParameterClass;
import com.kms.katalon.composer.testcase.model.InputValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;

public class AstInputValueTypeOptionsProvider {
    public static final String ARGUMENT_OPTIONS = "argument";
    public static final String CASE_OPTIONS = "case";
    public static final String FOR_OPTIONS = "for";
    public static final String SWITCH_OPTIONS = "switch";
    public static final String THROW_OPTIONS = "throw";
    public static final String STROKE_KEYS_OPTIONS = "stroke_keys";
    private static final InputValueType[] closureListOptions = new InputValueType[]{InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null, InputValueType.Variable, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.MethodCall, InputValueType.Binary, InputValueType.Property};
    private static final InputValueType[] argumentOptions = new InputValueType[]{InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null, InputValueType.Variable, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.Binary, InputValueType.Condition, InputValueType.TestCase, InputValueType.TestData, InputValueType.TestObject, InputValueType.MethodCall, InputValueType.Property, InputValueType.List, InputValueType.Map, InputValueType.Keys};
    private static final InputValueType[] globalVariableOptions = new InputValueType[]{InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null, InputValueType.TestDataValue, InputValueType.TestObject, InputValueType.TestData, InputValueType.Range, InputValueType.List, InputValueType.Map};
    private static final InputValueType[] caseOptions = new InputValueType[]{InputValueType.Variable, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.MethodCall, InputValueType.Condition, InputValueType.Binary, InputValueType.Property, InputValueType.List, InputValueType.Map, InputValueType.Range, InputValueType.Class, InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null};
    private static final InputValueType[] forOptions = new InputValueType[]{InputValueType.Range, InputValueType.ClosureList, InputValueType.List, InputValueType.Map, InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null, InputValueType.Variable, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.Property};
    private static final InputValueType[] keysOptions = new InputValueType[]{InputValueType.String, InputValueType.Key};
    private static final InputValueType[] strokeKeysOptions = new InputValueType[]{InputValueType.String, InputValueType.Keys};
    private static final InputValueType[] listOptions = new InputValueType[]{InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null, InputValueType.Variable, InputValueType.GlobalVariable, InputValueType.TestObject, InputValueType.TestDataValue, InputValueType.MethodCall, InputValueType.Property};
    private static final InputValueType[] mapOptions = new InputValueType[]{InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null, InputValueType.Variable, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.MethodCall, InputValueType.Property};
    private static final InputValueType[] rangeOptions = new InputValueType[]{InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null, InputValueType.Variable, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.MethodCall, InputValueType.Binary, InputValueType.Property};
    private static final InputValueType[] switchOptions = new InputValueType[]{InputValueType.Variable, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.MethodCall, InputValueType.Condition, InputValueType.Binary, InputValueType.Property, InputValueType.List, InputValueType.Map, InputValueType.Range, InputValueType.Class, InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null};
    private static final InputValueType[] testDataValueOptions = new InputValueType[]{InputValueType.Variable, InputValueType.TestData, InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null};
    private static final InputValueType[] variableOptions = new InputValueType[]{InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.TestObject, InputValueType.TestData, InputValueType.Range, InputValueType.Property, InputValueType.List, InputValueType.Map};
    private static final InputValueType[] methodCallOptions = new InputValueType[]{InputValueType.Class, InputValueType.This, InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null, InputValueType.Variable, InputValueType.MethodCall, InputValueType.Property};
    private static final InputValueType[] binaryOptions = new InputValueType[]{InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null, InputValueType.Variable, InputValueType.MethodCall, InputValueType.Binary, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.Property, InputValueType.Closure};
    private static final InputValueType[] booleanOptions = new InputValueType[]{InputValueType.Boolean, InputValueType.Variable, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.MethodCall, InputValueType.Condition, InputValueType.Binary, InputValueType.Property};
    private static final InputValueType[] throwOptions = new InputValueType[]{InputValueType.Throwable, InputValueType.Variable};
    private static final InputValueType[] stringOptions = new InputValueType[]{InputValueType.String, InputValueType.Null, InputValueType.Variable, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.MethodCall, InputValueType.Binary, InputValueType.Property};
    private static final InputValueType[] numberOptions = new InputValueType[]{InputValueType.Number, InputValueType.Null, InputValueType.Variable, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.MethodCall, InputValueType.Binary, InputValueType.Property};
    private static final InputValueType[] propertyOptions = new InputValueType[]{InputValueType.Class, InputValueType.Variable};
    private static final Map<String, InputValueType[]> valueTypeOptions = ImmutableMap.builder().put((Object)InputValueType.ClosureList.getName(), (Object)closureListOptions).put((Object)"argument", (Object)argumentOptions).put((Object)InputValueType.GlobalVariable.getName(), (Object)globalVariableOptions).put((Object)"case", (Object)caseOptions).put((Object)"for", (Object)forOptions).put((Object)InputValueType.Keys.getName(), (Object)keysOptions).put((Object)InputValueType.List.getName(), (Object)listOptions).put((Object)InputValueType.Map.getName(), (Object)mapOptions).put((Object)InputValueType.Range.getName(), (Object)rangeOptions).put((Object)"switch", (Object)switchOptions).put((Object)InputValueType.TestDataValue.getName(), (Object)testDataValueOptions).put((Object)InputValueType.Variable.getName(), (Object)variableOptions).put((Object)InputValueType.MethodCall.getName(), (Object)methodCallOptions).put((Object)InputValueType.Binary.getName(), (Object)binaryOptions).put((Object)InputValueType.Boolean.getName(), (Object)booleanOptions).put((Object)"throw", (Object)throwOptions).put((Object)InputValueType.String.getName(), (Object)stringOptions).put((Object)InputValueType.Number.getName(), (Object)numberOptions).put((Object)InputValueType.Property.getName(), (Object)propertyOptions).put((Object)"stroke_keys", (Object)strokeKeysOptions).build();

    private AstInputValueTypeOptionsProvider() {
    }

    public static InputValueType[] getInputValueTypeOptions(String name) {
        return valueTypeOptions.get(name);
    }

    public static InputValueType[] getInputValueTypeOptions(InputValueType inputValueType) {
        return valueTypeOptions.get(inputValueType.getName());
    }

    public static InputValueType getAssignableValueType(Class<?> paramClass) {
        InputValueType[] inputValueTypeArray = argumentOptions;
        int n = argumentOptions.length;
        int n2 = 0;
        while (n2 < n) {
            InputValueType inputValueType = inputValueTypeArray[n2];
            if (inputValueType.isAssignableTo(paramClass)) {
                return inputValueType;
            }
            ++n2;
        }
        return null;
    }

    public static InputValueType[] getAssignableInputValueTypes(Class<?> paramClass) {
        if (paramClass == null) {
            return new InputValueType[0];
        }
        ArrayList<InputValueType> inputValueTypeList = new ArrayList<InputValueType>();
        InputValueType[] inputValueTypeArray = argumentOptions;
        int n = argumentOptions.length;
        int n2 = 0;
        while (n2 < n) {
            InputValueType inputValueType = inputValueTypeArray[n2];
            if (inputValueType.isAssignableTo(paramClass)) {
                inputValueTypeList.add(inputValueType);
            }
            ++n2;
        }
        return inputValueTypeList.toArray(new InputValueType[inputValueTypeList.size()]);
    }

    public static InputValueType[] getAssignableInputValueTypes(InputParameterClass paramType) {
        if (paramType == null) {
            return new InputValueType[0];
        }
        if (paramType.isFailureHandlingTypeClass()) {
            return new InputValueType[]{InputValueType.Property};
        }
        LinkedHashSet<InputValueType> inputValueTypeList = new LinkedHashSet<InputValueType>(Arrays.asList(AstInputValueTypeOptionsProvider.getAssignableInputValueTypes(paramType.convertToClass())));
        if (paramType.isArray()) {
            inputValueTypeList.add(InputValueType.List);
        }
        return inputValueTypeList.toArray(new InputValueType[inputValueTypeList.size()]);
    }
}

