/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.schema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.math.BigDecimal;

public final class DoubleAttribute
extends AbstractFormatAttribute {
    private static final FormatAttribute INSTANCE = new DoubleAttribute();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private DoubleAttribute() {
        super("double", NodeType.NUMBER, new NodeType[0]);
    }

    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        if (instance instanceof NumericNode && ((NumericNode)instance).isNaN()) {
            report.error(this.newMsg(data, bundle, "err.format.double.overflow").put("key", "err.format.double.overflow").putArgument("value", instance));
        } else {
            BigDecimal converted;
            BigDecimal dec = instance.decimalValue();
            if (dec.compareTo(converted = BigDecimal.valueOf(dec.doubleValue())) != 0) {
                report.error(this.newMsg(data, bundle, "err.format.double.overflow").put("key", "err.format.double.overflow").putArgument("value", instance).putArgument("converted", (Object)converted));
            }
        }
    }
}

