/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.legacy;

import com.ibm.wsdl.xml.WSDLReaderImpl;
import java.io.File;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.reficio.ws.SoapBuilderException;
import org.reficio.ws.SoapContext;
import org.reficio.ws.annotation.ThreadSafe;
import org.reficio.ws.common.Wsdl11Writer;
import org.reficio.ws.legacy.SampleXmlUtil;
import org.reficio.ws.legacy.SchemaDefinitionWrapper;
import org.reficio.ws.legacy.SoapVersion;
import org.reficio.ws.legacy.WsdlUtils;
import org.reficio.ws.legacy.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@ThreadSafe
class SoapMessageBuilder {
    private static final Logger log = Logger.getLogger(SoapMessageBuilder.class);
    private Definition definition;
    private SchemaDefinitionWrapper definitionWrapper;

    public SoapMessageBuilder(URL wsdlUrl) throws WSDLException {
        WSDLReaderImpl reader = new WSDLReaderImpl();
        reader.setFeature("javax.wsdl.verbose", false);
        this.definition = reader.readWSDL(wsdlUrl.toString());
        this.definitionWrapper = new SchemaDefinitionWrapper(this.definition, wsdlUrl.toString());
    }

    public static SoapMessageBuilder createAndSave(URL wsdlUrl, File targetFolder, String fileBaseName) throws WSDLException {
        SoapMessageBuilder soapBuilder = new SoapMessageBuilder(wsdlUrl);
        URL url = soapBuilder.saveWsdl(fileBaseName, targetFolder);
        soapBuilder.getDefinition().setDocumentBaseURI(url.toString());
        return soapBuilder;
    }

    private static void saveDefinition(String fileBaseName, Definition definition, File targetFolder) {
        if (!targetFolder.exists() || !targetFolder.isDirectory()) {
            throw new IllegalArgumentException("Target folder does not exist or is not a folder [" + targetFolder.getPath() + "]");
        }
        Wsdl11Writer writer = new Wsdl11Writer(targetFolder);
        writer.writeWSDL(fileBaseName, definition);
    }

    private static URL getSavedWsdlUrl(String fileBaseName, File targetFolder) {
        File file = new File(targetFolder, fileBaseName + ".wsdl");
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new SoapBuilderException("Error saving url", (Throwable)e);
        }
    }

    public URL saveWsdl(String fileBaseName, File targetFolder) {
        SoapMessageBuilder.saveDefinition(fileBaseName, this.definition, targetFolder);
        return SoapMessageBuilder.getSavedWsdlUrl(fileBaseName, targetFolder);
    }

    public static URL saveWsdl(String fileBaseName, URL wsdlUrl, File targetFolder) throws WSDLException {
        WSDLReaderImpl reader = new WSDLReaderImpl();
        reader.setFeature("javax.wsdl.verbose", false);
        Definition definition = reader.readWSDL(wsdlUrl.toString());
        SoapMessageBuilder.saveDefinition(fileBaseName, definition, targetFolder);
        return SoapMessageBuilder.getSavedWsdlUrl(fileBaseName, targetFolder);
    }

    public String buildEmptyMessage(QName bindingQName, SoapContext context) {
        return SoapMessageBuilder.buildEmptyMessage(SoapMessageBuilder.getSoapVersion(this.getBindingByName(bindingQName)), context);
    }

    public String buildEmptyMessage(Binding binding, SoapContext context) {
        return SoapMessageBuilder.buildEmptyMessage(SoapMessageBuilder.getSoapVersion(binding), context);
    }

    public static String buildEmptyMessage(SoapVersion soapVersion, SoapContext context) {
        SampleXmlUtil generator = new SampleXmlUtil(false, context);
        return generator.createSample(soapVersion.getEnvelopeType());
    }

    public static String buildFault(String faultcode, String faultstring, SoapVersion soapVersion, SoapContext context) {
        SampleXmlUtil generator = new SampleXmlUtil(false, context);
        generator.setTypeComment(false);
        generator.setIgnoreOptional(true);
        String emptyResponse = SoapMessageBuilder.buildEmptyFault(generator, soapVersion, context);
        if (soapVersion == SoapVersion.Soap11) {
            emptyResponse = XmlUtils.setXPathContent(emptyResponse, "//faultcode", faultcode);
            emptyResponse = XmlUtils.setXPathContent(emptyResponse, "//faultstring", faultstring);
        } else if (soapVersion == SoapVersion.Soap12) {
            emptyResponse = XmlUtils.setXPathContent(emptyResponse, "//soap:Value", faultcode);
            emptyResponse = XmlUtils.setXPathContent(emptyResponse, "//soap:Text", faultstring);
            emptyResponse = XmlUtils.setXPathContent(emptyResponse, "//soap:Text/@xml:lang", "en");
        }
        return emptyResponse;
    }

    public String buildFault(String faultcode, String faultstring, QName bindingQName, SoapContext context) {
        return SoapMessageBuilder.buildFault(faultcode, faultstring, SoapMessageBuilder.getSoapVersion(this.getBindingByName(bindingQName)), context);
    }

    public String buildFault(String faultcode, String faultstring, Binding binding, SoapContext context) {
        return SoapMessageBuilder.buildFault(faultcode, faultstring, SoapMessageBuilder.getSoapVersion(binding), context);
    }

    public String buildEmptyFault(QName bindingQName, SoapContext context) {
        return SoapMessageBuilder.buildEmptyFault(SoapMessageBuilder.getSoapVersion(this.getBindingByName(bindingQName)), context);
    }

    public String buildEmptyFault(Binding binding, SoapContext context) {
        return SoapMessageBuilder.buildEmptyFault(SoapMessageBuilder.getSoapVersion(binding), context);
    }

    public static String buildEmptyFault(SoapVersion soapVersion, SoapContext context) {
        SampleXmlUtil generator = new SampleXmlUtil(false, context);
        String emptyResponse = SoapMessageBuilder.buildEmptyFault(generator, soapVersion, context);
        return emptyResponse;
    }

    public String buildSoapMessageFromInput(Binding binding, BindingOperation bindingOperation, SoapContext context) throws Exception {
        BindingInput bindingInput;
        SoapVersion soapVersion = SoapMessageBuilder.getSoapVersion(binding);
        boolean inputSoapEncoded = WsdlUtils.isInputSoapEncoded(bindingOperation);
        SampleXmlUtil xmlGenerator = new SampleXmlUtil(inputSoapEncoded, context);
        XmlObject object = XmlObject.Factory.newInstance();
        XmlCursor cursor = object.newCursor();
        cursor.toNextToken();
        cursor.beginElement(soapVersion.getEnvelopeQName());
        if (inputSoapEncoded) {
            cursor.insertNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            cursor.insertNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        }
        cursor.toFirstChild();
        cursor.beginElement(soapVersion.getBodyQName());
        cursor.toFirstChild();
        if (WsdlUtils.isRpc(this.definition, bindingOperation)) {
            this.buildRpcRequest(bindingOperation, soapVersion, cursor, xmlGenerator);
        } else {
            this.buildDocumentRequest(bindingOperation, cursor, xmlGenerator);
        }
        if (context.isAlwaysBuildHeaders() && (bindingInput = bindingOperation.getBindingInput()) != null) {
            List extensibilityElements = bindingInput.getExtensibilityElements();
            List<WsdlUtils.SoapHeader> soapHeaders = WsdlUtils.getSoapHeaders(extensibilityElements);
            this.addHeaders(soapHeaders, soapVersion, cursor, xmlGenerator);
        }
        cursor.dispose();
        try {
            StringWriter writer = new StringWriter();
            XmlUtils.serializePretty(object, writer);
            return writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return object.xmlText();
        }
    }

    public String buildSoapMessageFromOutput(Binding binding, BindingOperation bindingOperation, SoapContext context) throws Exception {
        BindingOutput bindingOutput;
        boolean inputSoapEncoded = WsdlUtils.isInputSoapEncoded(bindingOperation);
        SampleXmlUtil xmlGenerator = new SampleXmlUtil(inputSoapEncoded, context);
        SoapVersion soapVersion = SoapMessageBuilder.getSoapVersion(binding);
        XmlObject object = XmlObject.Factory.newInstance();
        XmlCursor cursor = object.newCursor();
        cursor.toNextToken();
        cursor.beginElement(soapVersion.getEnvelopeQName());
        if (inputSoapEncoded) {
            cursor.insertNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            cursor.insertNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        }
        cursor.toFirstChild();
        cursor.beginElement(soapVersion.getBodyQName());
        cursor.toFirstChild();
        if (WsdlUtils.isRpc(this.definition, bindingOperation)) {
            this.buildRpcResponse(bindingOperation, soapVersion, cursor, xmlGenerator);
        } else {
            this.buildDocumentResponse(bindingOperation, cursor, xmlGenerator);
        }
        if (context.isAlwaysBuildHeaders() && (bindingOutput = bindingOperation.getBindingOutput()) != null) {
            List extensibilityElements = bindingOutput.getExtensibilityElements();
            List<WsdlUtils.SoapHeader> soapHeaders = WsdlUtils.getSoapHeaders(extensibilityElements);
            this.addHeaders(soapHeaders, soapVersion, cursor, xmlGenerator);
        }
        cursor.dispose();
        try {
            StringWriter writer = new StringWriter();
            XmlUtils.serializePretty(object, writer);
            return writer.toString();
        }
        catch (Exception e) {
            log.warn((Object)"Exception during message generation", (Throwable)e);
            return object.xmlText();
        }
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public SchemaDefinitionWrapper getSchemaDefinitionWrapper() {
        return this.definitionWrapper;
    }

    public BindingOperation getOperationByName(QName bindingName, String operationName, String operationInputName, String operationOutputName) {
        Binding binding = this.getBindingByName(bindingName);
        if (binding == null) {
            return null;
        }
        BindingOperation operation = binding.getBindingOperation(operationName, operationInputName, operationOutputName);
        if (operation == null) {
            throw new SoapBuilderException("Operation not found");
        }
        return operation;
    }

    public Binding getBindingByName(QName bindingName) {
        Binding binding = this.definition.getBinding(bindingName);
        if (binding == null) {
            throw new SoapBuilderException("Binding not found");
        }
        return binding;
    }

    public List<QName> getBindingNames() {
        return new ArrayList<QName>(this.definition.getAllBindings().keySet());
    }

    public static SoapVersion getSoapVersion(Binding binding) {
        List list = binding.getExtensibilityElements();
        SOAPBinding soapBinding = WsdlUtils.getExtensiblityElement(list, SOAPBinding.class);
        if (soapBinding != null && (soapBinding.getTransportURI().startsWith("http://schemas.xmlsoap.org/soap/http") || soapBinding.getTransportURI().startsWith("http://schemas.microsoft.com/wse/2003/06/tcp"))) {
            return SoapVersion.Soap11;
        }
        SOAP12Binding soap12Binding = WsdlUtils.getExtensiblityElement(list, SOAP12Binding.class);
        if (soap12Binding != null && (soap12Binding.getTransportURI().startsWith("http://schemas.xmlsoap.org/soap/http") || soap12Binding.getTransportURI().startsWith("http://www.w3.org/2003/05/soap/bindings/HTTP/") || soap12Binding.getTransportURI().startsWith("http://schemas.microsoft.com/wse/2003/06/tcp"))) {
            return SoapVersion.Soap12;
        }
        throw new SoapBuilderException("SOAP binding not recognized");
    }

    private void addHeaders(List<WsdlUtils.SoapHeader> headers, SoapVersion soapVersion, XmlCursor cursor, SampleXmlUtil xmlGenerator) throws Exception {
        cursor.toStartDoc();
        cursor.toChild(soapVersion.getEnvelopeQName());
        cursor.toFirstChild();
        cursor.beginElement(soapVersion.getHeaderQName());
        cursor.toFirstChild();
        for (int i = 0; i < headers.size(); ++i) {
            WsdlUtils.SoapHeader header = headers.get(i);
            Message message = this.definition.getMessage(header.getMessage());
            if (message == null) {
                log.error((Object)("Missing message for header: " + header.getMessage()));
                continue;
            }
            Part part = message.getPart(header.getPart());
            if (part != null) {
                this.createElementForPart(part, cursor, xmlGenerator);
                continue;
            }
            log.error((Object)("Missing part for header; " + header.getPart()));
        }
    }

    private void buildDocumentResponse(BindingOperation bindingOperation, XmlCursor cursor, SampleXmlUtil xmlGenerator) throws Exception {
        Part[] parts = WsdlUtils.getOutputParts(bindingOperation);
        for (int i = 0; i < parts.length; ++i) {
            Part part = parts[i];
            if (WsdlUtils.isAttachmentOutputPart(part, bindingOperation) || part.getElementName() == null && part.getTypeName() == null) continue;
            XmlCursor c = cursor.newCursor();
            c.toLastChild();
            this.createElementForPart(part, c, xmlGenerator);
            c.dispose();
        }
    }

    private void buildDocumentRequest(BindingOperation bindingOperation, XmlCursor cursor, SampleXmlUtil xmlGenerator) throws Exception {
        Part[] parts = WsdlUtils.getInputParts(bindingOperation);
        for (int i = 0; i < parts.length; ++i) {
            Part part = parts[i];
            if (WsdlUtils.isAttachmentInputPart(part, bindingOperation) || part.getElementName() == null && part.getTypeName() == null) continue;
            XmlCursor c = cursor.newCursor();
            c.toLastChild();
            this.createElementForPart(part, c, xmlGenerator);
            c.dispose();
        }
    }

    private void createElementForPart(Part part, XmlCursor cursor, SampleXmlUtil xmlGenerator) throws Exception {
        QName elementName = part.getElementName();
        QName typeName = part.getTypeName();
        if (elementName != null) {
            cursor.beginElement(elementName);
            if (this.definitionWrapper.hasSchemaTypes()) {
                SchemaGlobalElement elm = this.definitionWrapper.getSchemaTypeLoader().findElement(elementName);
                if (elm != null) {
                    cursor.toFirstChild();
                    xmlGenerator.createSampleForType(elm.getType(), cursor);
                } else {
                    log.error((Object)("Could not find element [" + elementName + "] specified in part [" + part.getName() + "]"));
                }
            }
            cursor.toParent();
        } else {
            cursor.beginElement(part.getName());
            if (typeName != null && this.definitionWrapper.hasSchemaTypes()) {
                SchemaType type = this.definitionWrapper.getSchemaTypeLoader().findType(typeName);
                if (type != null) {
                    cursor.toFirstChild();
                    xmlGenerator.createSampleForType(type, cursor);
                } else {
                    log.error((Object)("Could not find type [" + typeName + "] specified in part [" + part.getName() + "]"));
                }
            }
            cursor.toParent();
        }
    }

    private void buildRpcRequest(BindingOperation bindingOperation, SoapVersion soapVersion, XmlCursor cursor, SampleXmlUtil xmlGenerator) throws Exception {
        String ns = WsdlUtils.getSoapBodyNamespace(bindingOperation.getBindingInput().getExtensibilityElements());
        if (ns == null) {
            ns = WsdlUtils.getTargetNamespace(this.definition);
            log.warn((Object)"missing namespace on soapbind:body for RPC request, using targetNamespace instead (BP violation)");
        }
        cursor.beginElement(new QName(ns, bindingOperation.getName()));
        if (xmlGenerator.isSoapEnc()) {
            cursor.insertAttributeWithValue(new QName(soapVersion.getEnvelopeNamespace(), "encodingStyle"), soapVersion.getEncodingNamespace());
        }
        Part[] inputParts = WsdlUtils.getInputParts(bindingOperation);
        for (int i = 0; i < inputParts.length; ++i) {
            XmlCursor c;
            Part part = inputParts[i];
            if (WsdlUtils.isAttachmentInputPart(part, bindingOperation)) {
                XmlCursor c2 = cursor.newCursor();
                c2.toLastChild();
                c2.beginElement(part.getName());
                c2.insertAttributeWithValue("href", part.getName() + "Attachment");
                c2.dispose();
                continue;
            }
            if (!this.definitionWrapper.hasSchemaTypes()) continue;
            QName typeName = part.getTypeName();
            if (typeName != null) {
                SchemaType type = this.definitionWrapper.findType(typeName);
                if (type != null) {
                    c = cursor.newCursor();
                    c.toLastChild();
                    c.insertElement(part.getName());
                    c.toPrevToken();
                    xmlGenerator.createSampleForType(type, c);
                    c.dispose();
                    continue;
                }
                log.warn((Object)("Failed to find type [" + typeName + "]"));
                continue;
            }
            SchemaGlobalElement element = this.definitionWrapper.getSchemaTypeLoader().findElement(part.getElementName());
            if (element != null) {
                c = cursor.newCursor();
                c.toLastChild();
                c.insertElement(element.getName());
                c.toPrevToken();
                xmlGenerator.createSampleForType(element.getType(), c);
                c.dispose();
                continue;
            }
            log.warn((Object)("Failed to find element [" + part.getElementName() + "]"));
        }
    }

    private void buildRpcResponse(BindingOperation bindingOperation, SoapVersion soapVersion, XmlCursor cursor, SampleXmlUtil xmlGenerator) throws Exception {
        String ns;
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        String string = ns = bindingOutput == null ? null : WsdlUtils.getSoapBodyNamespace(bindingOutput.getExtensibilityElements());
        if (ns == null) {
            ns = WsdlUtils.getTargetNamespace(this.definition);
            log.warn((Object)"missing namespace on soapbind:body for RPC response, using targetNamespace instead (BP violation)");
        }
        cursor.beginElement(new QName(ns, bindingOperation.getName() + "Response"));
        if (xmlGenerator.isSoapEnc()) {
            cursor.insertAttributeWithValue(new QName(soapVersion.getEnvelopeNamespace(), "encodingStyle"), soapVersion.getEncodingNamespace());
        }
        Part[] inputParts = WsdlUtils.getOutputParts(bindingOperation);
        for (int i = 0; i < inputParts.length; ++i) {
            XmlCursor c;
            Part part = inputParts[i];
            if (WsdlUtils.isAttachmentOutputPart(part, bindingOperation)) {
                XmlCursor c2 = cursor.newCursor();
                c2.toLastChild();
                c2.beginElement(part.getName());
                c2.insertAttributeWithValue("href", part.getName() + "Attachment");
                c2.dispose();
                continue;
            }
            if (!this.definitionWrapper.hasSchemaTypes()) continue;
            QName typeName = part.getTypeName();
            if (typeName != null) {
                SchemaType type = this.definitionWrapper.findType(typeName);
                if (type != null) {
                    c = cursor.newCursor();
                    c.toLastChild();
                    c.insertElement(part.getName());
                    c.toPrevToken();
                    xmlGenerator.createSampleForType(type, c);
                    c.dispose();
                    continue;
                }
                log.warn((Object)("Failed to find type [" + typeName + "]"));
                continue;
            }
            SchemaGlobalElement element = this.definitionWrapper.getSchemaTypeLoader().findElement(part.getElementName());
            if (element != null) {
                c = cursor.newCursor();
                c.toLastChild();
                c.insertElement(element.getName());
                c.toPrevToken();
                xmlGenerator.createSampleForType(element.getType(), c);
                c.dispose();
                continue;
            }
            log.warn((Object)("Failed to find element [" + part.getElementName() + "]"));
        }
    }

    private static String buildEmptyFault(SampleXmlUtil generator, SoapVersion soapVersion, SoapContext context) {
        String emptyResponse = SoapMessageBuilder.buildEmptyMessage(soapVersion, context);
        try {
            XmlObject xmlObject = XmlUtils.createXmlObject(emptyResponse);
            XmlCursor cursor = xmlObject.newCursor();
            if (cursor.toChild(soapVersion.getEnvelopeQName()) && cursor.toChild(soapVersion.getBodyQName())) {
                SchemaType faultType = soapVersion.getFaultType();
                Node bodyNode = cursor.getDomNode();
                Document dom = XmlUtils.parseXml(generator.createSample(faultType));
                bodyNode.appendChild(bodyNode.getOwnerDocument().importNode(dom.getDocumentElement(), true));
            }
            cursor.dispose();
            emptyResponse = xmlObject.toString();
        }
        catch (Exception e) {
            throw new SoapBuilderException((Throwable)e);
        }
        return emptyResponse;
    }
}

