/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.core.har;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarNameVersion;
import net.lightbody.bmp.core.har.HarPage;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HarLog {
    private final String version = "1.2";
    private volatile HarNameVersion creator;
    private volatile HarNameVersion browser;
    private final List<HarPage> pages = new CopyOnWriteArrayList<HarPage>();
    private final List<HarEntry> entries = new CopyOnWriteArrayList<HarEntry>();
    private volatile String comment = "";

    public HarLog() {
    }

    public HarLog(HarNameVersion creator) {
        this.creator = creator;
    }

    public void addPage(HarPage page) {
        this.pages.add(page);
    }

    public void addEntry(HarEntry entry) {
        this.entries.add(entry);
    }

    public String getVersion() {
        return "1.2";
    }

    public HarNameVersion getCreator() {
        return this.creator;
    }

    public void setCreator(HarNameVersion creator) {
        this.creator = creator;
    }

    public HarNameVersion getBrowser() {
        return this.browser;
    }

    public void setBrowser(HarNameVersion browser) {
        this.browser = browser;
    }

    public List<HarPage> getPages() {
        return this.pages;
    }

    public List<HarEntry> getEntries() {
        return this.entries;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

