/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy;

import java.util.EnumSet;

public enum CaptureType {
    REQUEST_HEADERS,
    REQUEST_COOKIES,
    REQUEST_CONTENT,
    REQUEST_BINARY_CONTENT,
    RESPONSE_HEADERS,
    RESPONSE_COOKIES,
    RESPONSE_CONTENT,
    RESPONSE_BINARY_CONTENT;

    private static final EnumSet<CaptureType> REQUEST_CAPTURE_TYPES;
    private static final EnumSet<CaptureType> RESPONSE_CAPTURE_TYPES;
    private static final EnumSet<CaptureType> HEADER_CAPTURE_TYPES;
    private static final EnumSet<CaptureType> NON_BINARY_CONTENT_CAPTURE_TYPES;
    private static final EnumSet<CaptureType> BINARY_CONTENT_CAPTURE_TYPES;
    private static final EnumSet<CaptureType> ALL_CONTENT_CAPTURE_TYPES;
    private static final EnumSet<CaptureType> COOKIE_CAPTURE_TYPES;

    static {
        REQUEST_CAPTURE_TYPES = EnumSet.of(REQUEST_HEADERS, REQUEST_CONTENT, REQUEST_BINARY_CONTENT, REQUEST_COOKIES);
        RESPONSE_CAPTURE_TYPES = EnumSet.of(RESPONSE_HEADERS, RESPONSE_CONTENT, RESPONSE_BINARY_CONTENT, RESPONSE_COOKIES);
        HEADER_CAPTURE_TYPES = EnumSet.of(REQUEST_HEADERS, RESPONSE_HEADERS);
        NON_BINARY_CONTENT_CAPTURE_TYPES = EnumSet.of(REQUEST_CONTENT, RESPONSE_CONTENT);
        BINARY_CONTENT_CAPTURE_TYPES = EnumSet.of(REQUEST_BINARY_CONTENT, RESPONSE_BINARY_CONTENT);
        ALL_CONTENT_CAPTURE_TYPES = EnumSet.of(REQUEST_CONTENT, RESPONSE_CONTENT, REQUEST_BINARY_CONTENT, RESPONSE_BINARY_CONTENT);
        COOKIE_CAPTURE_TYPES = EnumSet.of(REQUEST_COOKIES, RESPONSE_COOKIES);
    }

    public static EnumSet<CaptureType> getRequestCaptureTypes() {
        return EnumSet.copyOf(REQUEST_CAPTURE_TYPES);
    }

    public static EnumSet<CaptureType> getResponseCaptureTypes() {
        return EnumSet.copyOf(RESPONSE_CAPTURE_TYPES);
    }

    public static EnumSet<CaptureType> getHeaderCaptureTypes() {
        return EnumSet.copyOf(HEADER_CAPTURE_TYPES);
    }

    public static EnumSet<CaptureType> getNonBinaryContentCaptureTypes() {
        return EnumSet.copyOf(NON_BINARY_CONTENT_CAPTURE_TYPES);
    }

    public static EnumSet<CaptureType> getBinaryContentCaptureTypes() {
        return EnumSet.copyOf(BINARY_CONTENT_CAPTURE_TYPES);
    }

    public static EnumSet<CaptureType> getAllContentCaptureTypes() {
        return EnumSet.copyOf(ALL_CONTENT_CAPTURE_TYPES);
    }

    public static EnumSet<CaptureType> getCookieCaptureTypes() {
        return EnumSet.copyOf(COOKIE_CAPTURE_TYPES);
    }
}

