/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.dns;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.lightbody.bmp.proxy.dns.AdvancedHostResolver;

public abstract class AbstractHostNameRemapper
implements AdvancedHostResolver {
    private final AtomicReference<ImmutableMap<String, String>> remappedHostNames = new AtomicReference<ImmutableMap>(ImmutableMap.of());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remapHosts(Map<String, String> hostRemappings) {
        AtomicReference<ImmutableMap<String, String>> atomicReference = this.remappedHostNames;
        synchronized (atomicReference) {
            ImmutableMap newRemappings = ImmutableMap.copyOf(hostRemappings);
            this.remappedHostNames.set((ImmutableMap<String, String>)newRemappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remapHost(String originalHost, String remappedHost) {
        AtomicReference<ImmutableMap<String, String>> atomicReference = this.remappedHostNames;
        synchronized (atomicReference) {
            Map currentHostRemappings = (Map)this.remappedHostNames.get();
            LinkedHashMap builderMap = Maps.newLinkedHashMap((Map)currentHostRemappings);
            builderMap.remove(originalHost);
            builderMap.put(originalHost, remappedHost);
            ImmutableMap newRemappings = ImmutableMap.copyOf((Map)builderMap);
            this.remappedHostNames.set((ImmutableMap<String, String>)newRemappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHostRemapping(String originalHost) {
        AtomicReference<ImmutableMap<String, String>> atomicReference = this.remappedHostNames;
        synchronized (atomicReference) {
            Map currentHostRemappings = (Map)this.remappedHostNames.get();
            if (currentHostRemappings.containsKey(originalHost)) {
                LinkedHashMap builderMap = Maps.newLinkedHashMap((Map)currentHostRemappings);
                builderMap.remove(originalHost);
                ImmutableMap newRemappings = ImmutableMap.copyOf((Map)builderMap);
                this.remappedHostNames.set((ImmutableMap<String, String>)newRemappings);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearHostRemappings() {
        AtomicReference<ImmutableMap<String, String>> atomicReference = this.remappedHostNames;
        synchronized (atomicReference) {
            this.remappedHostNames.set((ImmutableMap<String, String>)ImmutableMap.of());
        }
    }

    @Override
    public Map<String, String> getHostRemappings() {
        return (Map)this.remappedHostNames.get();
    }

    @Override
    public Collection<String> getOriginalHostnames(String remappedHost) {
        ArrayList<String> originalHostnames = new ArrayList<String>();
        Map currentRemappings = (Map)this.remappedHostNames.get();
        for (Map.Entry entry : currentRemappings.entrySet()) {
            if (!((String)entry.getValue()).equals(remappedHost)) continue;
            originalHostnames.add((String)entry.getKey());
        }
        return originalHostnames;
    }

    public String applyRemapping(String originalHost) {
        String remappedHost = (String)this.remappedHostNames.get().get((Object)originalHost);
        if (remappedHost != null) {
            return remappedHost;
        }
        return originalHost;
    }

    public abstract Collection<InetAddress> resolveRemapped(String var1);

    @Override
    public Collection<InetAddress> resolve(String originalHost) {
        String remappedHost = this.applyRemapping(originalHost);
        return this.resolveRemapped(remappedHost);
    }
}

