/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.common;

import com.kms.katalon.common.utils.ProcessUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class ConsoleCommandExecutor {
    private static final String PATH = "PATH";
    private static final String PATH_SEPARATOR = ":";
    private static final String MAC_PATH_ENV_FILE = "/etc/paths";
    private static final String LINUX_ENV_FILE = "/etc/environment";
    private static final String[] ADDITIONAL_PATHS_MACOS = new String[]{"/opt/homebrew/bin"};
    private static String bestShell = null;
    private static final String[] SHELL_FOLDER = new String[]{"/bin", "/usr/bin", "/usr/local/bin", "/usr/local/sbin"};
    private static final String[] SHELL_PRIORITY = new String[]{"zsh", "bash", "dash", "sh"};
    private static final String[] DEFAULT_UNIX_SOURCE_FILES = new String[]{"/etc/profile", "/etc/bash.bashrc", "~/.bashrc", "/etc/zshenv", "~/.zshenv", "/etc/zprofile", "~/.zprofile", "/etc/zshrc", "~/.zshrc", "/etc/zlogin", "~/.zlogin", "~/.bash_profile", "~/.bash_login", "~/.profile"};

    private ConsoleCommandExecutor() {
    }

    public static List<String> runConsoleCommandAndCollectResults(String[] command, Map<String, String> addtionalEnvironmentVariables) throws IOException, InterruptedException {
        return ConsoleCommandExecutor.runConsoleCommandAndCollectResults(command, addtionalEnvironmentVariables, "", false);
    }

    public static List<String> runConsoleCommandAndCollectResults(String[] command, Map<String, String> addtionalEnvironmentVariables, boolean redirectErrorStream) throws IOException, InterruptedException {
        return ConsoleCommandExecutor.runConsoleCommandAndCollectResults(command, addtionalEnvironmentVariables, "", redirectErrorStream);
    }

    public static List<String> runConsoleCommandAndCollectResults(String[] command, Map<String, String> addtionalEnvironmentVariables, String directory, boolean redirectErrorStream) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(command);
        if (StringUtils.isNotEmpty((CharSequence)directory)) {
            pb.directory(new File(directory));
        }
        Map<String, String> existingEnvironmentVariables = pb.environment();
        existingEnvironmentVariables.putAll(addtionalEnvironmentVariables);
        pb.redirectErrorStream(redirectErrorStream);
        Process process = pb.start();
        ArrayList<String> resultLines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                resultLines.add(line);
            }
        }
        process.waitFor();
        return resultLines;
    }

    public static List<String> runConsoleCommandError(String[] command, Map<String, String> addtionalEnvironmentVariables, String directory) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(command);
        if (StringUtils.isNotEmpty((CharSequence)directory)) {
            pb.directory(new File(directory));
        }
        Map<String, String> existingEnvironmentVariables = pb.environment();
        existingEnvironmentVariables.putAll(addtionalEnvironmentVariables);
        Process process = pb.start();
        process.waitFor();
        ArrayList<String> resultLines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            String line;
            while ((line = br.readLine()) != null) {
                resultLines.add(line);
            }
        }
        return resultLines;
    }

    public static String runConsoleCommandAndCollectFirstResult(String[] command, Map<String, String> addtionalEnvironmentVariables, String directory) throws IOException, InterruptedException {
        List<String> resultLines = ConsoleCommandExecutor.runConsoleCommandAndCollectResults(command, addtionalEnvironmentVariables, directory, false);
        if (!resultLines.isEmpty()) {
            return resultLines.get(0);
        }
        return "";
    }

    public static String runConsoleCommandAndCollectFirstResult(String[] command, Map<String, String> addtionalEnvironmentVariables) throws IOException, InterruptedException {
        return ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult(command, addtionalEnvironmentVariables, "");
    }

    public static List<String> runConsoleCommandAndCollectResults(String[] command) throws IOException, InterruptedException {
        return ConsoleCommandExecutor.runConsoleCommandAndCollectResults(command, new HashMap<String, String>());
    }

    public static String runConsoleCommandAndCollectFirstResult(String[] command) throws IOException, InterruptedException {
        List<String> resultLines = ConsoleCommandExecutor.runConsoleCommandAndCollectResults(command);
        if (!resultLines.isEmpty()) {
            return resultLines.get(0);
        }
        return "";
    }

    public static String runConsoleCommandAndCollectFirstResult(String[] command, boolean redirectErrorStream) throws IOException, InterruptedException {
        List<String> resultLines = ConsoleCommandExecutor.runConsoleCommandAndCollectResults(command, new HashMap<String, String>(), "", redirectErrorStream);
        if (!resultLines.isEmpty()) {
            return resultLines.get(0);
        }
        return "";
    }

    public static boolean verifyModuleInstalled(String testCommand) {
        return ConsoleCommandExecutor.verifyModuleInstalled(testCommand, null);
    }

    public static boolean verifyModuleInstalled(String testCommand, String signal) {
        String program = StringUtils.contains((CharSequence)testCommand, (CharSequence)" ") ? testCommand.split(" ")[0] : testCommand;
        boolean isInstalled = ConsoleCommandExecutor.isInstalled(program);
        if (!isInstalled) {
            return false;
        }
        return StringUtils.isEmpty((CharSequence)signal) ? isInstalled : ConsoleCommandExecutor.test(testCommand, signal);
    }

    public static boolean isInstalled(String program) {
        return SystemUtils.IS_OS_WINDOWS ? ConsoleCommandExecutor.test(program) : ConsoleCommandExecutor.isInstalledUnix(program);
    }

    private static boolean isInstalledUnix(String program) {
        try {
            String sourceLoadingCommand = ConsoleCommandExecutor.getSourcesLoadingCommand();
            String testCommand = MessageFormat.format("{1}; which \"{0}\" | grep -i \"{0}\"", program, sourceLoadingCommand);
            List<String> result = ConsoleCommandExecutor.execSync(testCommand);
            return result.size() > 0 && !result.get(0).contains("not found");
        }
        catch (IOException | InterruptedException exception) {
            return false;
        }
    }

    public static boolean test(String program) {
        return ConsoleCommandExecutor.test(program, null);
    }

    public static boolean test(String program, String signal) {
        return SystemUtils.IS_OS_WINDOWS ? ConsoleCommandExecutor.windowsTest(program, signal) : ConsoleCommandExecutor.unixTest(program, signal);
    }

    private static boolean windowsTest(String program, String signal) {
        try {
            Process process = Runtime.getRuntime().exec(program);
            if (StringUtils.isNotBlank((CharSequence)signal)) {
                List<String> result = ProcessUtil.readSync(process);
                return ProcessUtil.includes(result, signal);
            }
            return true;
        }
        catch (IOException | InterruptedException exception) {
            return false;
        }
    }

    private static boolean unixTest(String program, String signal) {
        try {
            String sourceLoadingCommand = ConsoleCommandExecutor.getSourcesLoadingCommand();
            String testCommand = StringUtils.contains((CharSequence)program, (CharSequence)" ") ? program : MessageFormat.format("{1}; which \"{0}\"", program, sourceLoadingCommand);
            List<String> result = ConsoleCommandExecutor.execSync(testCommand);
            if (StringUtils.isNotBlank((CharSequence)signal)) {
                return ProcessUtil.includes(result, signal);
            }
            return result.size() > 0;
        }
        catch (IOException | InterruptedException exception) {
            return false;
        }
    }

    public static String safeWhere(String program) {
        try {
            return ConsoleCommandExecutor.where(program);
        }
        catch (IOException | InterruptedException exception) {
            return "";
        }
    }

    public static String where(String program) throws IOException, InterruptedException {
        String whereCommand = SystemUtils.IS_OS_WINDOWS ? MessageFormat.format("where {0}", program) : MessageFormat.format("{1}; which {0}", program, ConsoleCommandExecutor.getSourcesLoadingCommand());
        List<String> result = ConsoleCommandExecutor.execSync(whereCommand, false);
        String firstPath = result.stream().filter(pathI -> new File((String)pathI).exists()).findFirst().orElse(null);
        if (StringUtils.isBlank((CharSequence)firstPath)) {
            return "";
        }
        return new File(firstPath).toPath().toRealPath(new LinkOption[0]).toString();
    }

    public static String getSourcesLoadingCommand() {
        String HOME_DIR = Matcher.quoteReplacement(System.getProperty("user.home") + File.separator);
        Object[] defaultSourceCommands = Arrays.stream(DEFAULT_UNIX_SOURCE_FILES).filter(sourceI -> {
            String sourcePath = sourceI.replaceFirst("^~[/|\\\\]", HOME_DIR);
            File sourceFile = new File(sourcePath);
            return sourceFile.exists() && sourceFile.canRead();
        }).map(sourceI -> MessageFormat.format("source {0} > /dev/null 2>&1", sourceI)).collect(Collectors.toList()).toArray(new String[0]);
        return StringUtils.join((Object[])defaultSourceCommands, (String)"; ");
    }

    public static List<String> execSync(String command) throws IOException, InterruptedException {
        return ConsoleCommandExecutor.execSync(command, "");
    }

    public static List<String> execSync(String command, String workingDir) throws IOException, InterruptedException {
        return ConsoleCommandExecutor.execSync(command, workingDir, null);
    }

    public static List<String> execSync(String command, boolean redirectError) throws IOException, InterruptedException {
        return ConsoleCommandExecutor.execSync(command, redirectError, null);
    }

    public static List<String> execSync(String command, Map<String, String> additionalEnvs) throws IOException, InterruptedException {
        return ConsoleCommandExecutor.execSync(command, null, additionalEnvs);
    }

    public static List<String> execSync(String command, boolean redirectError, Map<String, String> additionalEnvs) throws IOException, InterruptedException {
        return ConsoleCommandExecutor.execSync(command, "", redirectError, additionalEnvs);
    }

    public static List<String> execSync(String command, String workingDir, boolean redirectError) throws IOException, InterruptedException {
        return ConsoleCommandExecutor.execSync(command, workingDir, redirectError, null);
    }

    public static List<String> execSync(String command, String workingDir, Map<String, String> additionalEnvs) throws IOException, InterruptedException {
        return ConsoleCommandExecutor.execSync(command, workingDir, true, additionalEnvs);
    }

    public static List<String> execSync(String command, String workingDir, boolean redirectError, Map<String, String> additionalEnvs) throws IOException, InterruptedException {
        Process process = ConsoleCommandExecutor.exec(command, workingDir, redirectError, additionalEnvs);
        if (process == null) {
            return Collections.emptyList();
        }
        return ProcessUtil.readSync(process);
    }

    public static Process exec(String command) throws IOException {
        return ConsoleCommandExecutor.exec(command, "");
    }

    public static Process exec(String command, String workingDir) throws IOException {
        return ConsoleCommandExecutor.exec(command, workingDir, null);
    }

    public static Process exec(String command, boolean redirectError) throws IOException {
        return ConsoleCommandExecutor.exec(command, redirectError, null);
    }

    public static Process exec(String command, Map<String, String> additionalEnvs) throws IOException {
        return ConsoleCommandExecutor.exec(command, null, additionalEnvs);
    }

    public static Process exec(String command, boolean redirectError, Map<String, String> additionalEnvs) throws IOException {
        return ConsoleCommandExecutor.exec(command, "", redirectError, additionalEnvs);
    }

    public static Process exec(String command, String workingDir, boolean redirectError) throws IOException {
        return ConsoleCommandExecutor.exec(command, workingDir, redirectError, null);
    }

    public static Process exec(String command, String workingDir, Map<String, String> additionalEnvs) throws IOException {
        return ConsoleCommandExecutor.exec(command, workingDir, true, additionalEnvs);
    }

    public static Process exec(String command, String workingDir, boolean redirectError, Map<String, String> additionalEnvs) throws IOException {
        ProcessBuilder processBuilder = ConsoleCommandExecutor.build(command, workingDir, redirectError, additionalEnvs);
        if (processBuilder == null) {
            return null;
        }
        return processBuilder.start();
    }

    public static ProcessBuilder build(String command) {
        return ConsoleCommandExecutor.build(command, "");
    }

    public static ProcessBuilder build(String command, String workingDir) {
        return ConsoleCommandExecutor.build(command, workingDir, null);
    }

    public static ProcessBuilder build(String command, boolean redirectError) {
        return ConsoleCommandExecutor.build(command, redirectError, null);
    }

    public static ProcessBuilder build(String command, Map<String, String> additionalEnvs) {
        return ConsoleCommandExecutor.build(command, null, additionalEnvs);
    }

    public static ProcessBuilder build(String command, boolean redirectError, Map<String, String> additionalEnvs) {
        return ConsoleCommandExecutor.build(command, "", redirectError, null);
    }

    public static ProcessBuilder build(String command, String workingDir, boolean redirectError) {
        return ConsoleCommandExecutor.build(command, workingDir, redirectError, null);
    }

    public static ProcessBuilder build(String command, String workingDir, Map<String, String> additionalEnvs) {
        return ConsoleCommandExecutor.build(command, workingDir, true, additionalEnvs);
    }

    public static ProcessBuilder build(String command, String workingDir, boolean redirectError, Map<String, String> additionalEnvs) {
        String[] commands;
        if (StringUtils.isBlank((CharSequence)command)) {
            return null;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            String[] windowsCommands;
            commands = windowsCommands = new String[]{"cmd.exe", "/C", command};
        } else {
            String bestShell = ConsoleCommandExecutor.findBestShell();
            if (StringUtils.isBlank((CharSequence)bestShell)) {
                bestShell = "/bin/sh";
            }
            String[] unixLikeCommands = new String[]{bestShell, "-c", command};
            commands = unixLikeCommands;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        processBuilder.redirectErrorStream(redirectError);
        Map<String, String> envs = processBuilder.environment();
        envs.putAll(ConsoleCommandExecutor.mergeEnvs(envs, additionalEnvs));
        if (StringUtils.isNotBlank((CharSequence)workingDir)) {
            processBuilder.directory(new File(workingDir));
        }
        return processBuilder;
    }

    private static String findBestShell() {
        if (StringUtils.isNotBlank((CharSequence)bestShell) && new File(bestShell).exists() && new File(bestShell).canExecute()) {
            return bestShell;
        }
        String[] stringArray = SHELL_PRIORITY;
        int n = SHELL_PRIORITY.length;
        int n2 = 0;
        while (n2 < n) {
            String shellI = stringArray[n2];
            String[] stringArray2 = SHELL_FOLDER;
            int n3 = SHELL_FOLDER.length;
            int n4 = 0;
            while (n4 < n3) {
                String shellDirI = stringArray2[n4];
                File shellFile = new File(shellDirI + File.separator + shellI);
                if (shellFile.exists() && shellFile.canExecute()) {
                    bestShell = shellFile.getAbsolutePath();
                    return bestShell;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private static Map<String, String> mergeEnvs(Map<String, String> existingEnvs, Map<String, String> additionalEnvs) {
        if (SystemUtils.IS_OS_MAC) {
            try {
                return ConsoleCommandExecutor.mergeMacEnvs(existingEnvs, additionalEnvs);
            }
            catch (IOException iOException) {
            }
        } else if (SystemUtils.IS_OS_LINUX) {
            try {
                return ConsoleCommandExecutor.mergeLinuxEnvs(existingEnvs, additionalEnvs);
            }
            catch (IOException iOException) {}
        }
        if (additionalEnvs != null) {
            existingEnvs.putAll(additionalEnvs);
        }
        return existingEnvs;
    }

    private static Map<String, String> mergeMacEnvs(Map<String, String> currentEnvs, Map<String, String> additionalEnvs) throws IOException {
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.putAll(currentEnvs);
        String mergedPath = ConsoleCommandExecutor.joinPaths(ConsoleCommandExecutor.getMacPathEnvVar(), currentEnvs.get(PATH));
        if (additionalEnvs != null) {
            mergedPath = ConsoleCommandExecutor.joinPaths(mergedPath, additionalEnvs.get(PATH));
            envs.putAll(additionalEnvs);
        }
        envs.put(PATH, mergedPath);
        return envs;
    }

    private static String getMacPathEnvVar() throws IOException {
        String systemPath;
        String path = systemPath = StringUtils.defaultString((String)System.getenv(PATH));
        File pathsFile = new File(MAC_PATH_ENV_FILE);
        if (pathsFile.exists()) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(pathsFile));){
                String line = reader.readLine();
                while (line != null) {
                    if (!StringUtils.isBlank((CharSequence)line)) {
                        path = ConsoleCommandExecutor.joinPaths(path, line.trim());
                    }
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        String[] stringArray = ADDITIONAL_PATHS_MACOS;
        int n = ADDITIONAL_PATHS_MACOS.length;
        int n2 = 0;
        while (n2 < n) {
            String pathI = stringArray[n2];
            path = ConsoleCommandExecutor.joinPaths(path, pathI);
            ++n2;
        }
        return path;
    }

    private static Map<String, String> mergeLinuxEnvs(Map<String, String> currentEnvs, Map<String, String> additionalEnvs) throws IOException {
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.putAll(currentEnvs);
        String mergedPath = ConsoleCommandExecutor.joinPaths(ConsoleCommandExecutor.getLinuxPathEnvVar(), currentEnvs.get(PATH));
        if (additionalEnvs != null) {
            mergedPath = ConsoleCommandExecutor.joinPaths(mergedPath, additionalEnvs.get(PATH));
            envs.putAll(additionalEnvs);
        }
        envs.put(PATH, mergedPath);
        return envs;
    }

    private static String getLinuxPathEnvVar() throws IOException {
        String systemPath;
        String path = systemPath = StringUtils.defaultString((String)System.getenv(PATH));
        File pathsFile = new File(LINUX_ENV_FILE);
        if (pathsFile.exists()) {
            String pathPrefix = MessageFormat.format("{0}=\"", PATH);
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(pathsFile));){
                String line = reader.readLine();
                while (line != null) {
                    if (!StringUtils.isBlank((CharSequence)line) && StringUtils.startsWith((CharSequence)line, (CharSequence)pathPrefix)) {
                        line = line.trim();
                        String trimmedPath = line.substring(pathPrefix.length(), line.length() - 1);
                        path = ConsoleCommandExecutor.joinPaths(path, trimmedPath);
                        break;
                    }
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return path;
    }

    private static String joinPaths(String ... paths) {
        HashSet distinctPaths = new HashSet();
        Arrays.stream(paths).filter(pathI -> StringUtils.isNotBlank((CharSequence)pathI)).forEachOrdered(pathI -> {
            if (pathI.contains(PATH_SEPARATOR)) {
                String[] subPaths = pathI.split(PATH_SEPARATOR);
                distinctPaths.addAll(Arrays.asList(subPaths));
            } else {
                distinctPaths.add(pathI);
            }
        });
        return String.join((CharSequence)PATH_SEPARATOR, distinctPaths);
    }
}

