/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumCreateSessionPayloadFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(SeleniumCreateSessionPayloadFilter.class);
    private MutableCapabilities capabilities;

    public SeleniumCreateSessionPayloadFilter(MutableCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public HttpHandler apply(HttpHandler next) {
        return req -> {
            try {
                if (this.capabilities != null && HttpMethod.POST == req.getMethod() && req.getUri().endsWith("/session")) {
                    String data = new String(((InputStream)req.getContent().get()).readAllBytes(), StandardCharsets.UTF_8);
                    if (StringUtils.isBlank((CharSequence)data)) {
                        return next.execute(req);
                    }
                    ObjectMapper objectMapper = new ObjectMapper();
                    Map contentData = (Map)objectMapper.readValue(data, Map.class);
                    if (contentData == null) {
                        return next.execute(req);
                    }
                    if (!contentData.containsKey("desiredCapabilities")) {
                        contentData.put("desiredCapabilities", this.capabilities.asMap());
                    }
                    req.setContent(Contents.utf8String((CharSequence)objectMapper.writeValueAsString((Object)contentData)));
                }
            }
            catch (Exception e) {
                logger.error("Exception while apply SeleniumCreateSessionPayloadFilter", (Throwable)e);
            }
            return next.execute(req);
        };
    }
}

