/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.elements;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.eclipse.codebrowsing.elements.IGroovyResolvedElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.ResolvedSourceMethod;
import org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.eclipse.jdt.internal.core.SourceMethodInfo;

public class GroovyResolvedSourceMethod
extends ResolvedSourceMethod
implements IGroovyResolvedElement {
    private final String extraDoc;
    private ASTNode inferredElement;

    public GroovyResolvedSourceMethod(JavaElement parent, String name, String[] parameterTypes, String uniqueKey, String extraDoc, ASTNode inferredElement) {
        super(parent, name, parameterTypes, uniqueKey);
        this.extraDoc = extraDoc;
        this.inferredElement = inferredElement;
    }

    @Override
    public String getExtraDoc() {
        return this.extraDoc;
    }

    @Override
    public ASTNode getInferredElement() {
        return this.inferredElement;
    }

    public SourceMethodElementInfo getElementInfo() throws JavaModelException {
        try {
            return (SourceMethodElementInfo)super.getElementInfo();
        }
        catch (JavaModelException jme) {
            if (!jme.getJavaModelStatus().isDoesNotExist() || !(this.inferredElement instanceof MethodNode)) {
                throw jme;
            }
            return new SourceMethodInfo(){
                {
                    MethodNode method = (MethodNode)GroovyResolvedSourceMethod.this.inferredElement;
                    this.setReturnType(method.getReturnType().getNameWithoutPackage().toCharArray());
                    this.setExceptionTypeNames(GroovyResolvedSourceMethod.buildExceptionTypeNames(method.getExceptions()));
                    this.setArgumentNames(GroovyResolvedSourceMethod.buildArgumentNames(method.getParameters()));
                    this.setNameSourceStart(method.getNameStart());
                    this.setNameSourceEnd(method.getNameEnd());
                    this.setSourceRangeStart(method.getStart());
                    this.setSourceRangeEnd(method.getEnd());
                    this.setFlags(method.getModifiers());
                }
            };
        }
    }

    private static char[][] buildArgumentNames(Parameter[] params) {
        int n;
        if (params != null && (n = params.length) > 0) {
            char[][] names = new char[n][];
            int i = 0;
            while (i < n) {
                names[i] = params[i].getName().toCharArray();
                ++i;
            }
            return names;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    private static char[][] buildExceptionTypeNames(ClassNode[] types) {
        int n;
        if (types != null && (n = types.length) > 0) {
            char[][] names = new char[n][];
            int i = 0;
            while (i < n) {
                names[i] = types[i].getNameWithoutPackage().toCharArray();
                ++i;
            }
            return names;
        }
        return CharOperation.NO_CHAR_CHAR;
    }
}

